/*
 * Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: log.h,v 1.19 2005/06/16 00:09:34 ca Exp $
 */

#ifndef SM_LOG_H
#define SM_LOG_H 1

#include "sm/generic.h"
#include "sm/varargs.h"
#include "sm/io.h"
#include "sm/syslog.h"

#if !HAVE_VSYSLOG
void	vsyslog(int _level, const char *_format, va_list _args);
#endif

/* see io.h */
#if 1
#define SMIOLOG_FILENO		SMIOERR_FILENO
#else
#define SMIOLOG_FILENO		SMIOOUT_FILENO
#endif
#define smiolog		(&SmIoF[SMIOLOG_FILENO])

/* Hack ... */
#define SM_LOG_EMERG	LOG_EMERG
#define SM_LOG_FATAL	LOG_EMERG
#define SM_LOG_ALERT	LOG_ALERT
#define SM_LOG_INCONS	LOG_CRIT	/* internal inconsistency */
#define SM_LOG_CRIT	LOG_CRIT
#define SM_LOG_ERROR	LOG_ERR
#define SM_LOG_ERR	SM_LOG_ERROR
#define SM_LOG_WARNING	LOG_WARNING
#define SM_LOG_WARN	SM_LOG_WARNING
#define SM_LOG_NOTICE	LOG_NOTICE
#define SM_LOG_INFO	LOG_INFO
#define SM_LOG_DEBUG	LOG_DEBUG

typedef struct sm_log_ctx_S 		sm_log_ctx_T, *sm_log_ctx_P;
typedef struct sm_logcategory_S		sm_logcategory_T, *sm_logcategory_P;
typedef struct sm_logconfig_S		sm_logconfig_T, *sm_logconfig_P;
typedef struct sm_logmodule_S		sm_logmodule_T, *sm_logmodule_P;
typedef struct sm_logdestination_S	sm_logdestination_T, *sm_logdestination_P;
typedef struct sm_rpool_S		sm_mem_T, *sm_mem_P;

/*
**  Used to name the categories used by a library.  An array of sm_logcategory
**  structures names each category, and the id value is initialized by calling
**  sm_log_registercategories.
*/

struct sm_logcategory_S
{
	const char	*smlc_name;	/* XXX sm_string_P ? */
	uint		 smlc_id;
};

/*
** Similar to sm_logcategory above, but for all the modules a library defines.
*/

struct sm_logmodule_S
{
	const char	*smlm_name;	/* XXX sm_string_P ? */
	uint		 smlm_id;
};


/*
**  As a first hack just map this stuff to some syslog functions?
*/

sm_ret_T sm_log_create(sm_mem_P _mctx, sm_log_ctx_P *_plctx, sm_logconfig_P *_plcfg);
sm_ret_T sm_log_destroy(sm_log_ctx_P _lctx);

sm_ret_T sm_logconfig_create(sm_log_ctx_P _lctx, sm_logconfig_P *_plcfg);
sm_ret_T sm_logconfig_use(sm_log_ctx_P _lctx, sm_logconfig_P _lcfg);
sm_logconfig_P	 sm_logconfig_get(sm_log_ctx_P _lctx);
sm_ret_T sm_logconfig_destroy(sm_logconfig_P _lcfg);

#if 0
sm_ret_T sm_log_registercategories(sm_log_ctx_P _lctx, sm_logcategory_T categories[]);
sm_ret_T sm_log_registermodules(sm_log_ctx_P _lctx, sm_logmodule_T modules[]);
#endif

sm_ret_T sm_log_createchannel(sm_logconfig_P _lcfg, const char *_name,
		      uint _type, int _priority, uint _level,
		      const sm_logdestination_P _destination,
		      uint _flags);
sm_ret_T sm_log_usechannel(sm_logconfig_P _lcfg, const char *_name,
		   const sm_logcategory_P _category,
		   const sm_logmodule_P _module);

sm_ret_T sm_log_setfile(sm_log_ctx_P _lctx, sm_file_T *_file);
sm_ret_T sm_log_setfilename(sm_log_ctx_P _lctx, char *_name);

sm_ret_T
#if SM_CHK_PRINTF
PRINTFLIKE(6, 7)
#endif
	sm_log_write(sm_log_ctx_P _lctx, sm_logcategory_P _category,
			sm_logmodule_P _module, int _priority, uint _level, const char *_format, ...);
sm_ret_T sm_log_vwrite(sm_log_ctx_P _lctx, sm_logcategory_P _category,
			sm_logmodule_P _module, int _priority, uint _level,
			const char *_format, va_list _args);
#if 0
sm_ret_T
#if SM_CHK_PRINTF
PRINTFLIKE(6, 7)
#endif
	sm_log_write1(sm_log_ctx_P _lctx, sm_logcategory_P _category,
	       sm_logmodule_P _module, int _priority, uint _level, const char *_format, ...);
sm_ret_T sm_log_vwrite1(sm_log_ctx_P _lctx, sm_logcategory_P _category,
		sm_logmodule_P _module, int _priority, uint _level,
		const char *_format, va_list _args);

sm_ret_T sm_log_iwrite(sm_log_ctx_P _lctx, sm_logcategory_P _category,
	       sm_logmodule_P _module, int _priority, uint _level,
	       sm_msgcat_P msgcat, int _msgset, int _msg,
	       const char *_format, ...);
sm_ret_T sm_log_ivwrite(sm_log_ctx_P _lctx, sm_logcategory_P _category,
	       sm_logmodule_P _module, int _priority, uint _level,
	       sm_msgcat_P msgcat, int _msgset, int _msg,
	       const char *_format, va_list _args);
sm_ret_T sm_log_iwrite1(sm_log_ctx_P _lctx, sm_logcategory_P _category,
		sm_logmodule_P _module, int _priority, uint _level,
		sm_msgcat_P msgcat, int _msgset, int _msg,
		const char *_format, ...);
sm_ret_T sm_log_ivwrite1(sm_l_ctxog_P _lctx, sm_logcategory_P _category,
		 sm_logmodule_P _module, int _priority, uint _level,
		 sm_msgcat_P msgcat, int _msgset, int _msg,
		 const char *_format, va_list _args);
#endif /* 0 */

sm_ret_T sm_log_setdebuglevel(sm_log_ctx_P _lctx, uint _level);
uint	 sm_log_getdebuglevel(sm_log_ctx_P _lctx);
bool	 sm_log_wouldlog(sm_log_ctx_P _lctx, uint _level);
#if 0
sm_ret_T sm_log_setduplicateinterval(sm_logconfig_P _lcfg, uint _interval);
uint	 sm_log_getduplicateinterval(sm_logconfig_P _lcfg);
#endif /* 0 */
sm_ret_T sm_log_settag(sm_logconfig_P _lcfg, const char *_tag);
sm_ret_T sm_log_gettag(sm_logconfig_P _lcfg);
sm_ret_T sm_log_opensyslog(const char *_tag, int _options, int _facility);
sm_ret_T sm_log_closesyslog(void);
sm_ret_T sm_log_closefilelogs(sm_log_ctx_P _lctx);
sm_ret_T sm_log_categorybyname(sm_log_ctx_P _lctx, const char *_name);
sm_ret_T sm_log_modulebyname(sm_log_ctx_P _lctx, const char *_name);
sm_ret_T sm_log_setcontext(sm_log_ctx_P _lctx);
sm_ret_T sm_log_setfp_fd(sm_log_ctx_P _lctx, sm_file_T *_fp, int _fd);
sm_ret_T sm_log_setfd(sm_log_ctx_P _lctx, int _fd);

sm_ret_T sm_log_reopen(sm_log_ctx_P _lctx);

#endif /* SM_LOG_H */
