#!/bin/sh
# $Id: t-rcb-1.sh,v 1.7 2004/12/29 20:53:09 ca Exp $
# Copyright (c) 2003, 2004 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# Test RCB, using t-rcbsrv t-rcbcl; rcb.in.*
# ------------------------------------------------------------
#
test -s stop && exit 1
#
SRV=./t-rcbsrv
CLT=./t-rcbcl
SOCK=s
SL=srv.log
CL=clt.log
SE=srv.err
CE=clt.err
SD=`dirname $0`
ERRS=0

for i in 0 1 2 3
do
  ${SRV} ${SOCK} > ${SL} 2> ${SE} &
  SP=$!
  sleep 1
  ${CLT} ${SOCK} > ${CL} 2> ${CE} < ${SD}/rcb.in.${i}
  (sleep 3; kill ${SP} >/dev/null 2>&1 ) &
  wait ${SP}
  if test -s ${SD}/rcb.out.${i}
  then
    diff -w ${SL} ${SD}/rcb.out.${i}
  else
    sed -e 's/^I.* \([SI]\)/\1=/' ${SD}/rcb.in.${i} > rcb.out.${i}
    diff -w ${SL} rcb.out.${i}
  fi
  ES=$?
  if test ${ES} != 0
  then
    ERRS=`expr ${ERRS} + 1 `
#     kill ${SP}
  fi
  rm -f ${SL} ${CL} ${SE} ${CE}
done

${SRV} ${SOCK} > ${SL} 2> ${SE} &
SP=$!
sleep 1
# fails, too large
${CLT} ${SOCK} > ${CL} 2> ${CE} < ${SD}/rcb.in.4 && ERRS=`expr ${ERRS} + 1 `
kill ${SP}
if grep '1 error in test!' ${CE} >/dev/null
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
fi

exit ${ERRS}
