/*
 * Copyright (c) 2002, 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-error-0.c,v 1.3 2004/09/03 18:13:02 ca Exp $")

#include <stdio.h>

#include "sm/error.h"
#include "sm/test.h"

int
main(int argc, char *argv[])
{
	sm_error_T e1;
	int m, t, v;

	sm_test_begin(argc, argv, "test error 0");
	m = 0;
	t = 1;
	v = 1;
	e1 = sm_error_gen(m, t, v);
#if SM_T_DEBUG
	printf("e1=0x%x mod=%d, type=%d, value=%d\n", e1,
		sm_error_module(e1), sm_error_type(e1), sm_error_value(e1));
#endif /* SM_T_DEBUG */
	SM_TEST(sm_error_module(e1) == m);
	SM_TEST(sm_error_type(e1) == t);
	SM_TEST(sm_error_value(e1) == v);

	m = 6;
	t = 1;
	v = 127;
	e1 = sm_error_gen(m, t, v);
#if SM_T_DEBUG
	printf("e1=0x%x mod=%d, type=%d, value=%d\n", e1,
		sm_error_module(e1), sm_error_type(e1), sm_error_value(e1));
#endif /* SM_T_DEBUG */
	SM_TEST(sm_error_module(e1) == m);
	SM_TEST(sm_error_type(e1) == t);
	SM_TEST(sm_error_value(e1) == v);

	return sm_test_end();
}
