/*
 * Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_IDSTR(id, "@(#)$Id: t-cdbfs-0.c,v 1.6 2005/04/14 17:08:56 ca Exp $")

#include "sm/fs.h"
#include "sm/statfs.h"
#include "sm/cdbfs.h"
#include "sm/io.h"
#include "sm/test.h"

static int Verbose;

#define CDB_ID	"S000000003FA45E9801"
#define CHG1	123

static sm_ret_T
fscdbtest(void)
{
	sm_ret_T ret;
	ulong f1, f2;
	cdb_fsctx_P cdb_fsctx;
#if !CDB_FS_CTX_LOCAL
	fs_ctx_P fs_ctx;
#endif

#if !CDB_FS_CTX_LOCAL
	ret = fs_ctx_open(16, &(fs_ctx));
	SM_TEST(ret == SM_SUCCESS);
	if (sm_is_err(ret))
		return ret;
#endif
	ret = cdb_fsctx_open(
#if !CDB_FS_CTX_LOCAL
			fs_ctx,
#endif
			&cdb_fsctx, &f1);
	SM_TEST(ret == SM_SUCCESS);
	SM_TEST(cdb_fsctx != NULL);
	if (cdb_fsctx == NULL)
		return ret;

	ret = cdb_sz_add(cdb_fsctx, CDB_ID, CHG1, &f2);
	SM_TEST(ret == SM_SUCCESS);
	SM_TEST(f1 - CHG1 == f2);

	ret = cdb_sz_rm(cdb_fsctx, CDB_ID, CHG1, &f2);
	SM_TEST(ret == SM_SUCCESS);
	SM_TEST(f1 == f2);

	ret = cdb_fsctx_close(cdb_fsctx);
	SM_TEST(ret == SM_SUCCESS);

#if !CDB_FS_CTX_LOCAL
	ret = fs_ctx_close(fs_ctx);
	SM_TEST(ret == SM_SUCCESS);
#endif

	return ret;
}

int
main(int argc, char *argv[])
{
	int c;
	char *dir, *prg;

	opterr = 0;
	Verbose = 0;
	dir = ".";
	prg = argv[0];
	while ((c = getopt(argc, argv, "V")) != -1)
	{
		switch (c)
		{
		  case 'V':
			++Verbose;
			break;
		  default:
			exit(1);
		}
	}
	argc -= optind;
	argv += optind;
	sm_test_begin(argc, argv, "test freediskspace");
	fscdbtest();
	return sm_test_end();
}
