#!/bin/sh
# $Id: t-alias-3.sh,v 1.20 2005/10/05 23:17:47 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# Script to test alias expansion for RFC2821 addresses (full addresses)
# Uses smar, t-smar-1, "aliases" map, t-mm, startsmar.sh
# ------------------------------------------------------------
#
test -s stop && exit 1
#

# path to programs
P=..
SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../smar
fi
. ${SD}/common.sh

OUT=alias-3.out
RES=alias-3.ip
GEN=alias-3.gen
OK=alias-3.ok
TPRG=./t-smar-1
ALIAS=alias-3
VERBOSE=false

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

killit()
{
if test -s ${PIDS}
then
  # stop MTA components
  for i in `cat ${PIDS}`
  do
    kill ${i}
  done
fi
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi
#rm -f ${MTMAP}
exit 1
}

rm -f ${SOCK} ${PIDS}
trap killit 1 2 3

# create mailertable (save old version?)
${CAT} > ${MT} <<EOF
local.dom	lmtp:
other.dom	[3.4.5.6]
b.c	lmtp:
x.y	[1.2.3.4]
y.z	[2.3.4.5]
EOF

# create map for smar
rm -f ${ALIMAP}
cat > ${ALIAS} <<EOF
user:	local:
a:	<a1@x.y> <a2@y.z>
a1@b.c:	<a1@x.y>
a2@b.c:	<a2@x.y> <a@local.dom>
a3@x.y:	<a3@y.z>
a4@x.y:	<a4@y.z> <a@local.dom>
a5@x.y:	<a5@y.z> <a4@x.y> <a@local.dom>
a6@x.y:	<a6@y.z>
EOF

${MM} < ${ALIAS}
if test $? -ne 0
then
  echo t-mm failed
  exit 1
fi

# start SMAR
# XREF: SMARCNF_FL_ALI_ALL: 4
SMAROPT="-A 4" ${SHELL} ${SD}/startsmar.sh || exit 1
rm -f ${OUT} ${RES} ${OK}

# Problem: the output isn't ordered (asynchronous operation, and
# hash table to list conversion).

TEST=1
# ----------------------------------------
${VALGRIND} ${TPRG} -A -VVV '<a1@b.c>' > ${OUT} 2>&1
egrep '^(IP|alias)' ${OUT} | sort > ${RES}
sort > ${OK} <<EOF
aliased=<a1@x.y>
IP[0]=1.2.3.4 [1020304]
EOF
if diff ${OK} ${RES}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed"
  test X"${SM_STOPONERROR}" != X && killit
fi

TEST=2
# ----------------------------------------
${VALGRIND} ${TPRG} -A -VVV '<a2@b.c>' > ${OUT} 2>&1
egrep '^(IP|alias)' ${OUT} | sort > ${RES}
sort > ${OK} <<EOF
aliases=3
alias 0/3
aliased=<a1@x.y>
IP[0]=1.2.3.4 [1020304]
alias 1/3
aliased=<a2@y.z>
IP[0]=2.3.4.5 [2030405]
alias 2/3
aliased=<a2@x.y>
IP[0]=1.2.3.4 [1020304]
EOF
if diff ${OK} ${RES}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed"
  test X"${SM_STOPONERROR}" != X && killit
fi

TEST=3
# ----------------------------------------
${VALGRIND} ${TPRG} -A -VVV '<a3@x.y>' > ${OUT} 2>&1
egrep '^(IP|alias)' ${OUT} | sort > ${RES}
sort > ${OK} <<EOF
aliased=<a3@y.z>
IP[0]=2.3.4.5 [2030405]
EOF
if diff ${OK} ${RES}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed"
  test X"${SM_STOPONERROR}" != X && killit
fi

TEST=4
# ----------------------------------------
${VALGRIND} ${TPRG} -A -VVV '<a4@x.y>' > ${OUT} 2>&1
egrep '^(IP|alias)' ${OUT} | sort > ${RES}
sort > ${OK} <<EOF
IP[0]=1.2.3.4 [1020304]
IP[0]=2.3.4.5 [2030405]
IP[0]=2.3.4.5 [2030405]
alias 0/3
alias 1/3
alias 2/3
aliased=<a1@x.y>
aliased=<a2@y.z>
aliased=<a4@y.z>
aliases=3
EOF
if diff ${OK} ${RES}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed"
  test X"${SM_STOPONERROR}" != X && killit
fi

TEST=5
# ----------------------------------------
${VALGRIND} ${TPRG} -A -VVV '<a5@x.y>' > ${OUT} 2>&1
egrep '^(IP|alias)' ${OUT} | sort > ${RES}
sort > ${OK} <<EOF
IP[0]=1.2.3.4 [1020304]
IP[0]=2.3.4.5 [2030405]
IP[0]=2.3.4.5 [2030405]
IP[0]=2.3.4.5 [2030405]
alias 0/4
alias 1/4
alias 2/4
alias 3/4
aliased=<a1@x.y>
aliased=<a2@y.z>
aliased=<a4@y.z>
aliased=<a5@y.z>
aliases=4
EOF
if diff ${OK} ${RES}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed"
  test X"${SM_STOPONERROR}" != X && killit
fi

TEST=6
# ----------------------------------------
${VALGRIND} ${TPRG} -A -VVV '<a6@x.y>' > ${OUT} 2>&1
egrep '^(IP|alias)' ${OUT} | sort > ${RES}
sort > ${OK} <<EOF
aliased=<a6@y.z>
IP[0]=2.3.4.5 [2030405]
EOF
if diff ${OK} ${RES}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed"
  test X"${SM_STOPONERROR}" != X && killit
fi

# stop SMAR
for i in `cat ${PIDS}`
do
  kill ${i}
done
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi
#rm -f ${MTMAP}

exit ${ERRS}
