#!/bin/sh
# $Id: t-alias-1.sh,v 1.24 2005/10/05 23:17:47 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# Script to test alias expansion for RFC2821 addresses.
# Uses smar, t-smar-1, "aliases" map, t-mm, startsmar.sh
# and t-hostname
# ------------------------------------------------------------
#
test -s stop && exit 1
#

# path to programs
P=..
SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../smar
fi
. ${SD}/common.sh

ALIAS=alias-1
OUT=alias-1.out
RES=alias-1.ip
OK=alias-1.ok
TPRG=./t-smar-1
VERBOSE=false

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# Note: reference to t-hostname! XREF
HOSTNAME=`../libmta/t-hostname -l -V 2>/dev/null`
killit()
{
if test -s ${PIDS}
then
  # stop MTA components
  for i in `cat ${PIDS}`
  do
    kill ${i}
  done
fi
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi
#rm -f ${MTMAP}
exit 1
}

# create map for smar
rm -f ${ALIMAP}
cat > ${ALIAS} <<EOF
user:	local:
a:	<a1@x.y> <a2@y.z>
in2:	<out1@x.y> <int2@b.c>
int2:	<out2@x.y>
loop1:	<loop1@b.c> <int2@b.c>
loop2:	<l2@b.c> <int2@b.c>
l2:	<loop2@b.c> <ext2@b.c>
ext1:	<ex1@sm9.org>
extl1:	<ex2@sm9.org> <ex3@sm9.org>
ll1:	<e1@sm9.org> <e2@sm9.org> <e3@sm9.org> <e4@sm9.org> <e5@sm9.org> <e6@sm9.org> <e7@sm9.org> <e8@sm9.org> <e9@sm9.org>
r1:	<r2@b.c>
r2:	<r3@b.c>
r3:	<r4@b.c>
r4:	<r5@b.c>
r5:	<user@local.dom>
f1:	<o1@x.y> f2@f3
t1:	<t1@x.y> <tf1@temp.fail>
p1:	<p1@x.y> <pf1@perm.fail>
EOF

${MM} < ${ALIAS}
if test $? -ne 0
then
  echo t-mm failed
  exit 1
fi

rm -f ${SOCK} ${PIDS}
trap killit 1 2 3

# create mailertable (save old version?)
${CAT} > ${MT} <<EOF
local.dom	lmtp:
b.c	lmtp:
x.y	[1.2.3.4]
y.z	[2.3.4.5]
temp.fail	4
perm.fail	5
${HOSTNAME}	lmtp:
EOF

# Note: the test programs which rely on failures from SMAR work only if
# SMAR has been compiled with -DSMAR_TEST!
SMAR_TEST=false
../smar/smar -D | grep "SMAR_TEST" >/dev/null && SMAR_TEST=true

# start SMAR
${SHELL} ${SD}/startsmar.sh || exit 1
rm -f ${OUT} ${RES} ${OK}

# Problem: the output isn't ordered (asynchronous operation, and
# hash table to list conversion).

TEST=1
# ----------------------------------------
# check output somehow...
${VALGRIND} ${TPRG} -VVV '<a@b.c>' > ${OUT} 2>&1
egrep '^(IP|alias)' ${OUT} | sort > ${RES}
sort > ${OK} <<EOF
aliases=2
alias 0/2
aliased=<a1@x.y>
IP[0]=1.2.3.4 [1020304]
alias 1/2
aliased=<a2@y.z>
IP[0]=2.3.4.5 [2030405]
EOF
if diff ${OK} ${RES}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed"
  test X"${SM_STOPONERROR}" != X && killit
fi

TEST=2
# ----------------------------------------
# check output somehow...
${VALGRIND} ${TPRG} -VVV '<in2@b.c>' > ${OUT} 2>&1
egrep '^(IP|alias)' ${OUT} | sort > ${RES}
sort > ${OK} <<EOF
aliases=2
alias 0/2
aliased=<out1@x.y>
IP[0]=1.2.3.4 [1020304]
alias 1/2
aliased=<out2@x.y>
IP[0]=1.2.3.4 [1020304]
EOF
if diff ${OK} ${RES}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed"
  test X"${SM_STOPONERROR}" != X && killit
fi

TEST=3
# ----------------------------------------
# check output somehow...
${VALGRIND} ${TPRG} -VVV -M '<extl1@local.dom>' > ${OUT} 2>&1
egrep '^(IP|alias)' ${OUT} | sort > ${RES}
sort > ${OK} <<EOF
aliases=2
alias 0/2
aliased=<ex3@sm9.org>
IP[0]=63.195.85.27 [3fc3551b]
alias 1/2
aliased=<ex2@sm9.org>
IP[0]=63.195.85.27 [3fc3551b]
EOF
if diff ${OK} ${RES}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed"
  test X"${SM_STOPONERROR}" != X && killit
fi

TEST=4
# ----------------------------------------
# check output somehow...
${VALGRIND} ${TPRG} -VVV -O -M '<ll1@local.dom>' > ${OUT} 2>&1
egrep '^(IP|aliase)' ${OUT} | sed -e 's/^alias [^:]*://' -e 's/:ttl.*//' | sort > ${RES}
sort > ${OK} <<EOF
aliased=<e1@sm9.org>:IP[0]=63.195.85.27 [3fc3551b]:pref[0]=10
aliased=<e2@sm9.org>:IP[0]=63.195.85.27 [3fc3551b]:pref[0]=10
aliased=<e3@sm9.org>:IP[0]=63.195.85.27 [3fc3551b]:pref[0]=10
aliased=<e4@sm9.org>:IP[0]=63.195.85.27 [3fc3551b]:pref[0]=10
aliased=<e5@sm9.org>:IP[0]=63.195.85.27 [3fc3551b]:pref[0]=10
aliased=<e6@sm9.org>:IP[0]=63.195.85.27 [3fc3551b]:pref[0]=10
aliased=<e7@sm9.org>:IP[0]=63.195.85.27 [3fc3551b]:pref[0]=10
aliased=<e8@sm9.org>:IP[0]=63.195.85.27 [3fc3551b]:pref[0]=10
aliased=<e9@sm9.org>:IP[0]=63.195.85.27 [3fc3551b]:pref[0]=10
aliases=9
EOF
if diff ${OK} ${RES}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed"
  test X"${SM_STOPONERROR}" != X && killit
fi

TEST=5
# ----------------------------------------
# check output somehow...
${VALGRIND} ${TPRG} -VVV '<r1@b.c>' > ${OUT} 2>&1
egrep '^(IP|alias|WARN|ERR)' ${OUT} > ${RES}
cat > ${OK} <<EOF
WARN: lookup=alias_nested_too_deep
EOF
if diff ${OK} ${RES}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed"
  test X"${SM_STOPONERROR}" != X && killit
fi

TEST=6
# ----------------------------------------
# check output somehow...
${VALGRIND} ${TPRG} '<f1@b.c>' > ${OUT} 2>&1
egrep '^(IP|alias|WARN|ERR)' ${OUT} > ${RES}
cat > ${OK} <<EOF
WARN: lookup=perm
EOF
if diff ${OK} ${RES}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed"
  test X"${SM_STOPONERROR}" != X && killit
fi

TEST=7
# ----------------------------------------
if ${SMAR_TEST}
then
# check output somehow...
${VALGRIND} ${TPRG} '<t1@b.c>' > ${OUT} 2>&1
egrep '^(IP|alias|WARN|ERR)' ${OUT} | sort > ${RES}
sort > ${OK} <<EOF
IP[0]=1.2.3.4 [1020304]
WARN: lookup=temp_fail aliased=<tf1@temp.fail>
alias 0/2
alias 1/2
aliased=<t1@x.y>
aliases=2
EOF
if diff ${OK} ${RES}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed"
  test X"${SM_STOPONERROR}" != X && killit
fi
fi

TEST=8
# ----------------------------------------
if ${SMAR_TEST}
then
# check output somehow...
${VALGRIND} ${TPRG} '<p1@b.c>' > ${OUT} 2>&1
egrep '^(IP|alias|WARN|ERR)' ${OUT} | sort > ${RES}
sort > ${OK} <<EOF
IP[0]=1.2.3.4 [1020304]
WARN: lookup=perm aliased=<pf1@perm.fail>
alias 0/2
alias 1/2
aliased=<p1@x.y>
aliases=2
EOF
if diff ${OK} ${RES}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed"
  test X"${SM_STOPONERROR}" != X && killit
fi
fi

# stop SMAR
for i in `cat ${PIDS}`
do
  kill ${i}
done
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi
rm -f ${MTMAP}

exit ${ERRS}
