#!/bin/sh
# $Id: t-strmapaddr-0.sh,v 1.2 2005/06/29 22:59:15 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# Script to test lookup of addresses using a "str" map
# Uses t-mapaddrr-0
# ------------------------------------------------------------
#
test -s stop && exit 1
#

CMP=cmp0
OK=ok0
DIFF=diff0
ERRS=0
P=./t-mapaddrr-0

TEST=0
# Input String Result
while read I S R
do
# echo ";$I;$S;$R;"
echo $I |
 ${P} -s $S 2>&1 |
  grep -v ' tests completed ' > ${CMP}
echo $R >${OK}
diff ${CMP} ${OK} > ${DIFF}
if test $? != 0
then
  echo "errors in test ${TEST}"
  echo ";$I;$S;$R;"
  cat ${DIFF}
  ERRS=`expr ${ERRS} + 1 `
fi
TEST=`expr ${TEST} + 1 `
done <<EOF
tag:user:detail:nice.domain	tag:user+detail@nice.domain	ret=0, rhs='T'
tag:user:detail:nice.domain	tag:user++@nice.domain	ret=0, rhs='T'
tag:user:detail:nice.domain	tag:user+*@nice.domain	ret=0, rhs='T'
tag:user:detail:nice.domain	tag:user*@nice.domain	ret=0, rhs='T'
tag:user:detail:nice.domain	tag:user+detail@.domain	ret=0, rhs='T'
tag:user:detail:nice.domain	tag:user@nice.domain	ret=80040108, rhs=''
tag:user:detail:nice.domain	tag:user@not.domain	ret=80040108, rhs=''
EOF

exit ${ERRS}
