/*
 * Copyright (c) 2003, 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-mapdom-0.c,v 1.17 2005/08/08 17:23:11 ca Exp $")

#include "sm/error.h"
#include "sm/heap.h"
#include "sm/memops.h"
#include "sm/test.h"
#include "sm/maps.h"
#include "sm/mapc.h"
#include "sm/map.h"
#include "sm/mapclasses.h"
#include "sm/bdb.h"

#include "sm/io.h"

static int Verbose = 0;

#define MAPC_TYPE	"hash"
#define MAPC_NAME	"bdb2"
#define MAPC_FILE	"./bdb2.db"

static void
usage(char *prg)
{
	sm_io_fprintf(smioerr,
		"%s: usage: %s [options] key rhs [key rhs]...\n"
		"key can be of form \"tag:domain\"\n"
		"rhs is the expected output\n"
		"use map %s\n"
		"options:\n"
		"  -d   lookup just dot too [default: lookup just tag]\n"
		, prg, prg
		, MAPC_FILE);
}

int
main(int argc, char *argv[])
{
	int c;
	uint taglen, keylen;
	uint32_t flags;
	char *prg, *key1, *rhs1, *colon;
	sm_ret_T ret;
	sm_maps_P maps;
	sm_map_P map;
	sm_cstr_P mtype, mname;
	sm_str_P rhs, tagp;
	sm_str_T tag;
	sm_str_T key;
	sm_str_P domain;

	prg = argv[0];
	flags = SMMAP_LFL_TAG;
	while ((c = getopt(argc, argv, "dV")) != -1)
	{
		switch (c)
		{
		  case 'd':
			flags = SMMAP_LFL_DOT;
			break;
		  case 'V':
			++Verbose;
			break;
		  default:
			usage(argv[0]);
			return 1;
		}
	}
	argc -= optind;
	argv += optind;

	sm_test_begin(argc, argv, "test map doman");

	maps = NULL;
	mtype = mname = NULL;
	rhs = NULL;

	ret = sm_maps_init(&maps);
	SM_TEST(maps != NULL);
	if (maps == NULL)
		goto error;
	SM_TEST(sm_is_success(ret));

	mtype = sm_cstr_scpyn0((const uchar *)MAPC_TYPE, strlen(MAPC_TYPE));
	SM_TEST(mtype != NULL);
	if (mtype == NULL)
		goto error;

	mname = sm_cstr_scpyn0((const uchar *)MAPC_NAME, strlen(MAPC_NAME));
	SM_TEST(mname != NULL);
	if (mname == NULL)
		goto error;

	rhs = sm_str_new(NULL, 256, 1024);
	SM_TEST(rhs != NULL);
	if (rhs == NULL)
		goto error;

	ret = sm_bdb_class_create(maps);
	SM_TEST(sm_is_success(ret));

	map = NULL;
	ret = sm_map_open(maps, mname, mtype, 0, MAPC_FILE, SMAP_MODE_RDONLY,
			&map, SMPO_END);
	SM_CSTR_FREE(mtype);
	SM_CSTR_FREE(mname);
	SM_TEST(sm_is_success(ret));
	if (!sm_is_success(ret))
		goto error;

	/* perform some operations ... */

	for (c = 0; c < argc - 1; c += 2)
	{
		key1 = argv[c];
		rhs1 = argv[c + 1];

		sm_str_clr(rhs);
		colon = strchr(key1, ':');
		if (colon != NULL)
		{
			taglen = colon - key1 + 1;
			sm_str_assign(tag, NULL, (uchar *)key1, taglen,
				taglen);
			tagp = &tag;
			keylen = strlen(key1) - (colon - key1);
			SM_TEST(keylen > 1);
			--keylen;
			sm_str_assign(key, NULL, (uchar *)(colon + 1),
				keylen, keylen);
		}
		else
		{
			tagp = NULL;
			sm_str_assign(key, NULL, (uchar *)key1, strlen(key1),
				strlen(key1));
		}
		domain = &key;
		ret = sm_map_lookup_domain(map, (sm_rdstr_P) domain, tagp,
					flags, rhs);
		if (rhs1[0] != '\0')
		{
			SM_TEST(sm_is_success(ret));
			SM_TEST(strcmp(rhs1, (char *)sm_str_getdata(rhs)) == 0);
			if (Verbose > 0 &&
			    strcmp(rhs1, (char *)sm_str_getdata(rhs)) != 0)
				sm_io_fprintf(smioerr,
					"key=%s, rhs1=%s, rhs=%S\n",
					key1, rhs1, rhs);
		}
	}

	ret = sm_map_close(map, 0);
	SM_TEST(sm_is_success(ret));

	ret = sm_maps_term(maps);
	SM_TEST(sm_is_success(ret));
	maps = NULL;

  error:
	SM_STR_FREE(rhs);
	if (maps != NULL)
		sm_maps_term(maps);
	return sm_test_end();
}
