/*
 * Copyright (c) 2003, 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: xtextify.c,v 1.5 2004/12/29 23:47:35 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/str.h"

/*
**  XTEXTIFY -- take regular text and turn it into DSN-style xtext
**
**	Parameters:
**		t -- the text to convert.
**		taboo -- additional characters that must be encoded.
**		str -- string to fill.
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
xtextify(char *t, char *taboo, sm_str_P str)
{
	char *p;
	int c, l, nbogus;
	sm_ret_T ret;

	if (taboo == NULL)
		taboo = "";

	/* figure out how long this xtext will have to be */
	nbogus = l = 0;
	for (p = t; *p != '\0'; p++)
	{
		c = (*p & 0xff);

		/* ASCII dependence here -- this is the way the spec words it */
		if (c < '!' || c > '~' || c == '+' || c == '\\' || c == '(' ||
		    strchr(taboo, c) != NULL)
			nbogus++;
		l++;
	}
	if (nbogus < 0)
		return sm_err_perm(E2BIG);
	l += nbogus * 2 + 1;
	ret = sm_str_space(str, l);
	if (sm_is_err(ret))
		return ret;

	/* ok, copy the text with byte expansion */
	for (ret = SM_SUCCESS; *t != '\0' && !sm_is_err(ret); ++t)
	{
		c = (*t & 0xff);

		/* ASCII dependence here -- this is the way the spec words it */
		if (c < '!' || c > '~' || c == '+' || c == '\\' || c == '(' ||
		    strchr(taboo, c) != NULL)
		{
			ret = sm_str_put(str, (uchar) '+');
			if (sm_is_err(ret))
				break;
			ret = sm_str_put(str, (uchar) "0123456789ABCDEF"[c >> 4]);
			if (sm_is_err(ret))
				break;
			ret = sm_str_put(str, (uchar) "0123456789ABCDEF"[c & 0xf]);
		}
		else
			ret = sm_str_put(str, (uchar) c);
	}
	return ret;
}
