/*
 * Copyright (c) 2002, 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: tree-depth.c,v 1.5 2004/12/29 23:47:34 ca Exp $")

#include "sm/error.h"
#include "sm/assert.h"
#include "sm/tree.h"

/*
**  SM_TREE_DEPTH -- return maximum depth of a tree
**
**	Parameters:
**		n -- tree
**
**	Returns:
**		maximum depth of tree
*/

uint
sm_tree_depth(sm_tree_node_P n)
{
	uint l, r;

	if (n == NULL)
		return 0;
	l = sm_tree_depth(n->sm_tree_left);
	r = sm_tree_depth(n->sm_tree_right);
	if (l >= r)
		return l + 1;
	else
		return r + 1;
}
