/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-getsmtpsid.c,v 1.2 2005/03/02 19:04:46 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/mta.h"
#include "sm/io.h"
#include "sm/test.h"

static int Verbose = 0;

static int
tstgetsmtpsid(id_count_T idc)
{
	sm_ret_T ret;
	int r;
	sessta_id_T ta_id;
	int smtpsid;

	for (smtpsid = 0; smtpsid <= SMTPS_MAX_SMTPS_ID; smtpsid++)
	{
		/* generate TA id */
		r = sm_snprintf(ta_id, SMTP_STID_SIZE, SMTPS_STID_FORMAT,
			idc, smtpsid);
		SM_TEST(r != -1);
		ret = sm_getsmtpsid(ta_id);
		SM_TEST(ret == smtpsid);
	}
	return 0;
}

static int
testgetsmtpsid(void)
{
	uint j;
	id_count_T idc;
	id_count_T idcs[] =
		{
		0, 1, 16, 31, 32, 63, 64, 127, 128, 255, 256
		, 1023, 1024, 4095, 4096
		, 0x07FFFFFF, 0x0FFFFFFF, 0x08000000, 0x08000001
		, 0x17FFFFFF, 0x1FFFFFFF, 0x18000000, 0x18000001
		, 0x27FFFFFF, 0x2FFFFFFF, 0x28000000, 0x28000001
		, 0x37FFFFFF, 0x3FFFFFFF, 0x38000000, 0x38000001
		, 0x57FFFFFF, 0x5FFFFFFF, 0x58000000, 0x58000001
		, 0xA7FFFFFF, 0xAFFFFFFF, 0xA8000000, 0xA8000001
		, 0xE7FFFFFF, 0xEFFFFFFF, 0xE8000000, 0xE8000001
		, 0x7FFFFFFF, 0xFFFFFFFF
		};

	for (j = 0; j < SM_ARRAY_SIZE(idcs); j++)
	{
		idc = idcs[j];
		tstgetsmtpsid(idc);
	}
	return 0;
}

int
main(int argc, char **argv)
{
	int c;

	while ((c = getopt(argc, argv, "V")) != -1)
	{
		switch (c)
		{
		  case 'V':
			++Verbose;
			break;
		  default:
			break;
		}
	}
	sm_test_begin(argc, argv, "test getsmtpsid");
	argc -= optind;
	argv += optind;

	(void) testgetsmtpsid();

	return sm_test_end();
}
