/*
 * Copyright (c) 2003, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: strunquote.c,v 1.3 2005/06/09 00:43:41 ca Exp $")
#include "sm/assert.h"
#include "sm/error.h"
#include "sm/ctype.h"
#include "sm/str.h"
#include "sm/str-int.h"

/*
**  SM_STR_UNQUOTE -- remove surrounding quotes from str
**
**	Parameters:
**		str -- string
**
**	Returns:
**		usual error code
*/

sm_ret_T
sm_str_unquote(sm_str_P str)
{
	uint i, len;

	SM_IS_BUF(str);

	len = sm_str_getlen(str);
	if (len > 2
	    && sm_str_rd_elem(str, 0) == '"'
	    && sm_str_rd_elem(str, len - 1) == '"')
	{
		for (i = 0; i < len - 2; i++)
			sm_str_wr_elem(str, i, sm_str_rd_elem(str, i + 1));
		sm_str_wr_elem(str, len - 2, '\0');
		SM_STR_SETLEN(str, len - 2);
	}
	return SM_SUCCESS;
}
