/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: sockaccept.c,v 1.1 2005/08/24 20:56:17 ca Exp $")
#include "sm/assert.h"
#include "sm/error.h"
#include "sm/fcntl.h"
#include "sm/socket.h"
#include "sm/net.h"

/*
**  SOCKET_ACCEPT -- Accept an incoming network connection.
**
**	Parameters:
**		listenfd -- fd that we are listening on
**		addr -- client address that is connecting (output)
**		addrlen -- length of addr (in/out)
**		pfd -- (pointer to) file descriptor (output)
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
socket_accept(int listenfd, sm_sockaddr_P addr, sockaddr_len_T *addrlen, int *pfd)
{
	int connfd;

	SM_REQUIRE(listenfd >= 0);
	SM_REQUIRE(addr != NULL);
	SM_REQUIRE(addrlen != NULL);
	SM_REQUIRE(pfd != NULL);

	connfd = accept(listenfd, &(addr->sa), addrlen);
	if (connfd == INVALID_SOCKET)
	{
		if (errno != EAGAIN)
			return sm_error_perm(SM_EM_NET, errno);
		else
			return sm_error_temp(SM_EM_NET, errno);
	}

	if (addr->sa.sa_family == AF_INET)
	{
		int sockopt;

		sockopt = 1;
		if (setsockopt(connfd, SOL_SOCKET, SO_KEEPALIVE,
			       (void *) &sockopt, sizeof(sockopt)) == -1)
			return sm_error_perm(SM_EM_NET, errno);
	}
	*pfd = connfd;
	return SM_SUCCESS;
}
