/*
 * Copyright (c) 2002, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: rcbget.c,v 1.9 2005/06/02 19:00:36 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/error.h"
#include "sm/memops.h"
#include "sm/rpool.h"
#include "sm/rcb.h"
#if SM_STR_CHECK

/*
**  SM_RCB_GET -- Get one char from the current read position of rcb.
**
**	Parameters:
**		rcb -- sm_rcb_P object to append onto.
**
**	Returns:
**		character read if available;
**		sm_error_perm(SM_EM_RECCOM, SM_E_OVFLW_NS) otherwise
*/

int
sm_rcb_get(sm_rcb_P rcb)
{
	SM_IS_RCB(rcb);
	if (rcb->sm_rcb_rw < 0)
		return sm_error_perm(SM_EM_RECCOM, SM_E_OVFLW_NS);
	if (rcb->sm_rcb_len <= (uint)rcb->sm_rcb_rw)
		return sm_error_perm(SM_EM_RECCOM, SM_E_OVFLW_NS);
	return rcb->sm_rcb_base[rcb->sm_rcb_rw++];
}
#endif /* SM_STR_CHECK */
