/*
 * Copyright (c) 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: prtfmtted.c,v 1.3 2004/08/26 20:55:44 ca Exp $")
#include "sm/string.h"
#include "sm/ctype.h"
#include "sm/io.h"
#include "sm/util.h"

#define MAX_LINE_LEN	80

/*
**  PRT_FMTTED -- print a text such it doesn't exceed a certain length
**	per line and add a prefix
**
**	Parameters:
**		fp -- file to use
**		indent -- indentation
**		prefix -- prefix string for each line
**		comment -- string to print
**
**	Returns:
**		none
*/

void
prt_fmtted(sm_file_T *fp, int indent, const char *prefix, const char *comment)
{
	int offset, len, index, rest, prelen;

	SM_REQUIRE(fp != NULL);
	SM_REQUIRE(indent >= 0);
	SM_REQUIRE(comment != NULL);
	SM_REQUIRE(prefix != NULL);
	offset = 0;
	len = strlen(comment);
	prelen = strlen(prefix);
	rest = len;

	/* is line too long to fit? */
	while (rest > MAX_LINE_LEN - indent - prelen)
	{
		/* last position to fit; search to left for space */
		index = offset + MAX_LINE_LEN - indent - prelen;
		while (index > offset && !isspace(comment[index]))
			--index;
		if (index > offset)
		{
			sm_io_fprintf(fp, "%*s%s%.*s\n", indent, ""
				, prefix
				, (int) (index - offset)
				, comment + offset);
			offset += index + 1;
			rest = len - index;
		}
		else
			break;
	}
	sm_io_fprintf(fp, "%*s%s%s\n", indent, "", prefix, comment + offset);
}
