/*
 * Copyright (c) 2003 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: myhostname.c,v 1.1 2003/05/10 17:41:00 ca Exp $")
#include "sm/assert.h"
#include "sm/error.h"
#include "sm/memops.h"
#include "sm/str.h"
#include "sm/net.h"
#include "sm/hostname.h"

/*
**  SM_MYHOSTNAME -- Simple version to determine local host name
**
**	Parameters:
**		pmhn -- (pointer to) hostname (output)
**
**	Returns:
**		usual return code
**
**	Note:
**		This function is NOT thread safe because it uses
**		gethostbyname().  Hence this function must be called before
**		threads are started if it is used from a multi-threaded
**		application.
*/

sm_ret_T
sm_myhostname(sm_str_P *pmhn)
{
	size_t l;
	int r;
	char *name, **ha;
	struct hostent *hp;
	char hostname[MAXHOSTNAMELEN];

	SM_REQUIRE(pmhn != NULL);
	r = gethostname(hostname, sizeof(hostname));
	if (r == -1)
	{
#define MYNAME "localhost.localdomain"
		strlcpy(hostname, MYNAME, sizeof(hostname));
	}
	hp = gethostbyname(hostname);
	if (hp == NULL)
		return sm_err_perm(errno);

	name = hp->h_name;
	ha = NULL;
	l = 0;
	while (name != NULL)
	{
		l = strlen(name) + 1;
		if (l > 1 && strchr(name, '.') != NULL)
			break;
		if (ha == NULL)
			ha = hp->h_aliases;
		else
			++ha;
		if (ha == NULL || *ha == NULL)
			break;
		name = *ha;
	}
	if (l <= 1)
		return sm_err_perm(EINVAL);
	*pmhn = sm_str_scpyn0(NULL, name, l, l);
	if (*pmhn == NULL)
		return sm_err_temp(ENOMEM);
	return SM_SUCCESS;
}
