/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: getsmtpsid.c,v 1.3 2005/01/01 00:40:06 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/io.h"
#include "sm/mta.h"

/*
**  SM_GETSMTPSID -- Extract SMTPS id from session/transaction id
**
**	Parameters:
**		se_id -- session/transaction id
**
**	Returns:
**		>=0: smtps id
**		<0: usual sm_error code
*/

sm_ret_T
sm_getsmtpsid(sessta_id_P se_id)
{
	int r, i;

	SM_REQUIRE(se_id != NULL);
	r = sm_io_sscanf(se_id + SMTPS_STID_PID_OFF, "%x", &i);
	if (r != 1 || i < 0 || i > SMTPS_MAX_SMTPS_ID)
		return sm_err_perm(EINVAL);
	return i;
}
