/*
 * Copyright (c) 2004 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: sm-conf-state.h,v 1.5 2005/06/16 00:39:03 ca Exp $
 */

#ifndef SM_CONF_STATE_H
#define SM_CONF_STATE_H 1

#if SM_LIBCONF_ALONE
#include "sm-conf.h"
#include <stdlib.h>
#else
#include "sm/magic.h"
#include "sm/sm-conf.h"
#endif

#include "sm-conf-node.h"

/* SM-CONF-STATE.H -- internal state declaration. */

typedef struct sm_conf_error_S sm_conf_error_T;

struct sm_conf_error_S
{
	sm_conf_error_T		*sce_next;
	char			 sce_text[SM_CONF_ERROR_BUFFER_SIZE];
} ;

#define SM_CONF_MAGIC SM_MAGIC('C', 'O', 'N', 'F')
#define SM_IS_CONF(sm_conf)	\
	SM_REQUIRE((sm_conf) != NULL &&	\
		(sm_conf)->sm_magic == SM_CONF_MAGIC)

struct sm_conf_S
{
	sm_magic_T	  sm_magic;
	char const	 *smc_name;	/* name of configuration file */
	size_t		  smc_line;	/* current line number */

	/*
	**  Buffer for entire configuration data: all input is read into
	**  this buffer and then the actual configuration tree points to
	**  text in the buffer which may get modified to '\0' terminate
	**  strings.
	**  _i: current read index
	**  _n: while writing into buf: next position to write,
	**	while reading from buf: last valid position (end of buf)
	**  _m: while writing into buf: end of allocated buf
	**	((ca) this doesn't really need to be in the context)
	*/

	char		 *smc_buf;
	size_t		  smc_buf_i;
	size_t		  smc_buf_n;
	size_t		  smc_buf_m;

	sm_conf_node_T	 *smc_root;

	/* (ca) use queue.h macros? */
	sm_conf_error_T	 *smc_error_head;
	sm_conf_error_T	**smc_error_tail;
	size_t		  smc_error_n;
};

int sm_conf_error_add(sm_conf_T *smc, char const *fmt, ...);

#endif	/* SM_CONF_STATE_H */
