/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 * $Id: sscnfdef.h,v 1.76 2005/10/25 23:33:40 ca Exp $
 */

#ifndef SM_SSCNFDEF_H
#define SM_SSCNFDEF_H 1

#include "sm/generic.h"
#include "sm/types.h"
#include "sm/time.h"
#include "sm/sm-conf.h"
#include "sm/sm-conf-time.h"
#include "sm/sm-conf-byte.h"
#include "sm/mta.h"
#include "sm/cnf.h"
#include "sm/sscnf.h"
#include "sm/ssdef.h"
#include "sm/smtpdef.h"

#if SM_SSCNFDEF
#define SM_SOCKCNFDEF 1
#endif
#include "sm/sockcnfdef.h"

#include "sm/mcpcnfs.h"

#if SM_USE_SASL
#include "sm/sasl.h"
#endif /* SM_USE_SASL */

#define SS_PR_CNF	"protected_recipients"
#define SS_PR_A_SENDER	"sender"
#define SS_PR_A_CLTADDR	"client_ip"
#define SS_PR_USE_LOOKUP	"generic_lookup"
#define SS_IMPLDET	"implicitly_match_detail"

#if SM_SSCNFDEF
#define EXTERN
#else
#define EXTERN extern
#endif

#if SM_USE_SASL
EXTERN
sm_conf_definition_T const
ss_auth_flag_names[]
#if SM_SSCNFDEF
=
{
{ SM_CONF_DEF_MAGIC,
	"noplaintext",			sm_conf_type_choice_value,
	SASL_SEC_NOPLAINTEXT,
	0, NULL, 0, NULL, NULL, NULL,
	"do not allow mechanisms that are susceptable to simple passive attack" },
{ SM_CONF_DEF_MAGIC,
	"noactive",			sm_conf_type_choice_value,
	SASL_SEC_NOACTIVE,
	0, NULL, 0, NULL, NULL, NULL,
	"do not allow mechanisms that are susceptable to active attacks" },
{ SM_CONF_DEF_MAGIC,
	"nodictionary",			sm_conf_type_choice_value,
	SASL_SEC_NODICTIONARY,
	0, NULL, 0, NULL, NULL, NULL,
	"do not allow mechanisms that are susceptable to passive dictionary attack" },
{ SM_CONF_DEF_MAGIC,
	"forward_secrecy",		sm_conf_type_choice_value,
	SASL_SEC_FORWARD_SECRECY,
	0, NULL, 0, NULL, NULL, NULL,
	"allow only mechanism with forward secrecy (breaking one session won't help break the next)" },
{ SM_CONF_DEF_MAGIC,
	"noanonymous",			sm_conf_type_choice_value,
	SASL_SEC_NOANONYMOUS,
	0, NULL, 0, NULL, NULL, NULL,
	"do not allow anonymous mechanisms" },
{ SM_CONF_DEF_MAGIC,
	"pass_credentials",		sm_conf_type_choice_value,
	SASL_SEC_PASS_CREDENTIALS,
	0, NULL, 0, NULL, NULL, NULL,
	"require mechanisms that can pass client credentials" },
{ SM_CONF_DEF_MAGIC,
	"mutual_auth",			sm_conf_type_choice_value,
	SASL_SEC_MUTUAL_AUTH,
	0, NULL, 0, NULL, NULL, NULL,
	"require mechanisms that support mutual authentication" },

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_SSCNFDEF */
;

#endif /* SM_USE_SASL */

EXTERN
sm_conf_definition_T const
ss_flag_names[]
#if SM_SSCNFDEF
=
{
{ SM_CONF_DEF_MAGIC,
	"8bitmime",		sm_conf_type_choice_value,
	SSC_CFL_8BITMIME,
	0, NULL, 0, NULL, NULL, NULL,
	"offer 8BITMIME" },
{ SM_CONF_DEF_MAGIC,
	"access",		sm_conf_type_choice_value,
	SSC_CFL_ACCESS_DB,
	0, NULL, 0, NULL, NULL, NULL,
	"use access map" },
{ SM_CONF_DEF_MAGIC,
	"greylisting",		sm_conf_type_choice_value,
	SSC_CFL_GREY,
	0, NULL, 0, NULL, NULL, NULL,
	"enable greylisting" },
{ SM_CONF_DEF_MAGIC,
	"delay_greylisting_error_until_DATA",	sm_conf_type_choice_value,
	SSC_CFL_GREY_DATA,
	0, NULL, 0, NULL, NULL, NULL,
	"delay an error from greylisting until the DATA command" },

{ SM_CONF_DEF_MAGIC,
	SS_IMPLDET,		sm_conf_type_choice_value,
	SSC_CFL_ACCIMPLDET,
	0, NULL, 0, NULL, NULL, NULL,
	"implicitly match +detail without specifying +* or *"	},

{ SM_CONF_DEF_MAGIC,
	"delay_checks",		sm_conf_type_choice_value,
	SSC_CFL_DELAY_CHKS,
	0, NULL, 0, NULL, NULL, NULL,
	"delay returning results from access check until RCPT stage" },
{ SM_CONF_DEF_MAGIC,
	"require_EHLO_before_MAIL",	sm_conf_type_choice_value,
	SSC_CFL_EHLO_REQ,
	0, NULL, 0, NULL, NULL, NULL,
	"require EHLO or HELO command before MAIL" },
{ SM_CONF_DEF_MAGIC,
	"spam_friend",		sm_conf_type_choice_value,
	SSC_CFL_SPAM_FRIEND,
	0, NULL, 0, NULL, NULL, NULL, NULL },
{ SM_CONF_DEF_MAGIC,
	"spam_hater",		sm_conf_type_choice_value,
	SSC_CFL_SPAM_HATER,
	0, NULL, 0, NULL, NULL, NULL, NULL },
{ SM_CONF_DEF_MAGIC,
	"background",		sm_conf_type_choice_value,
	SSC_CFL_BACKGROUND,
	0, NULL, 0, NULL, NULL, NULL, NULL },
{ SM_CONF_DEF_MAGIC,
	"serialize_accept",	sm_conf_type_choice_value,
	SSC_CFL_SERIAL_ACC,
	0, NULL, 0, NULL, NULL, NULL, NULL },
{ SM_CONF_DEF_MAGIC,
	"soft_bounce",	sm_conf_type_choice_value,
	SSC_CFL_SOFTBOUNCE,
	0, NULL, 0, NULL, NULL, NULL,
	"change permanent errors (5xy) into temporary errors (4xy)" },
{ SM_CONF_DEF_MAGIC,
	"lmtp_does_not_imply_relaying",	sm_conf_type_choice_value,
	SSC_CFL_LMTPNOTRELAY,
	0, NULL, 0, NULL, NULL, NULL,
	"do not implicitly allow relaying to domains that have lmtp: as RHS in mailertable" },

{ SM_CONF_DEF_MAGIC,
	"strict_ehlo_checks",		sm_conf_type_choice_value,
	SSC_CFL_EHLO_CHECKS,
	0, NULL, 0, NULL, NULL, NULL,
	"perform strict checks for HELO/EHLO parameter" },

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_SSCNFDEF */
;

EXTERN
sm_conf_definition_T const
ss_protrcpt_allow_names[]
#if SM_SSCNFDEF
=
{
{ SM_CONF_DEF_MAGIC,
	SS_PR_A_SENDER,			sm_conf_type_choice_value,
	SSC_CFL_PROTBYMAIL,
	0, NULL, 0, NULL, NULL, NULL,
	"protect recipients by sender address" },

{ SM_CONF_DEF_MAGIC,
	SS_PR_A_CLTADDR,		sm_conf_type_choice_value,
	SSC_CFL_PROTBYCLTADDR,
	0, NULL, 0, NULL, NULL, NULL, 
	"protect recipients by client IPv4 address" },

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_SSCNFDEF */
;
EXTERN
sm_conf_definition_T const
ss_protrcpt_match_names[]
#if SM_SSCNFDEF
=
{
/*
{ SM_CONF_DEF_MAGIC,
	"exact",		sm_conf_type_choice_value,
	0x0,
	0, NULL, 0, NULL, NULL, NULL, NULL },
*/

{ SM_CONF_DEF_MAGIC,
	SS_PR_USE_LOOKUP,		sm_conf_type_choice_value,
	SSC_CFL_PROTMAP,
	0, NULL, 0, NULL, NULL, NULL,
	"use generic lookup algorithm" },

{ SM_CONF_DEF_MAGIC,
	SS_IMPLDET,			sm_conf_type_choice_value,
	SSC_CFL_PROTIMPLDET,
	0, NULL, 0, NULL, NULL, NULL,
	"implicitly match +detail"	},

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_SSCNFDEF */
;

EXTERN
sm_conf_definition_T const
ss_protrcpt_defs[]
#if SM_SSCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, "allow_by",		sm_conf_type_choice,
	offsetof(ss_cnf_T, ss_cnf_cflags),	sizeof(uint32_t),
	NULL, SM_CONF_FLAG_STRICTLY_REQUIRED|SM_CONF_FLAG_MULTIPLE,
	ss_protrcpt_allow_names, NULL,	NULL,
	"allow by"	},

{ SM_CONF_DEF_MAGIC, "match_type",		sm_conf_type_choice,
	offsetof(ss_cnf_T, ss_cnf_cflags),	sizeof(uint32_t),
	NULL, SM_CONF_FLAG_OR, ss_protrcpt_match_names, NULL,	NULL,
	"match type"	},

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_SSCNFDEF */
;


#if SM_USE_PMILTER
EXTERN
sm_conf_definition_T const
ss_pm_flag_names[]
#if SM_SSCNFDEF
=
{
#if 0
/* default ... */
{ SM_CONF_DEF_MAGIC,
	"ignore",		sm_conf_type_choice_value,
	SSC_MFL_PM_IGN,
	0, NULL, 0, NULL, NULL, NULL, NULL },
/* should not be used either */
{ SM_CONF_DEF_MAGIC,
	"tempfail",		sm_conf_type_choice_value,
	SSC_MFL_PM_TEMP,
	0, NULL, 0, NULL, NULL, NULL, NULL },
#endif /* 0 */
{ SM_CONF_DEF_MAGIC,
	"abort",		sm_conf_type_choice_value,
	SSC_MFL_PM_421,
	0, NULL, 0, NULL, NULL, NULL,
	"abort session on communication error" },

{ SM_CONF_DEF_MAGIC,
	"accept_but_reconnect",		sm_conf_type_choice_value,
	SSC_MFL_PM_AGAIN,
	0, NULL, 0, NULL, NULL, NULL,
	"try to reconnect on communication error, accept current session" },

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_SSCNFDEF */
;
#endif /* SM_USE_PMILTER */


#if SM_USE_TLS
EXTERN
sm_conf_definition_T const
ss_tls_flag_names[]
#if SM_SSCNFDEF
=
{
{ SM_CONF_DEF_MAGIC,
	"allow_relaying_if_verified",		sm_conf_type_choice_value,
	SSC_CFL_TLS_REL_VRFY,
	0, NULL, 0, NULL, NULL, NULL,
	"allow relaying if client cert has been verified" },
{ SM_CONF_DEF_MAGIC,
	"check_access_map_for_relaying",	sm_conf_type_choice_value,
	SSC_CFL_TLS_REL_ACC,
	0, NULL, 0, NULL, NULL, NULL,
	"perform access map lookups to allow relaying"},

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_SSCNFDEF */
;

EXTERN
sm_conf_definition_T
ss_tls_defs[]
#if SM_SSCNFDEF
=
{

{ SM_CONF_DEF_MAGIC, "cert_file",	sm_conf_type_string,
	offsetof(ss_cnf_T, ss_cnf_cert),	0,
	SM_MTA_CERT,
	0,	NULL,	NULL,	NULL,
	"File with certificate in PEM format" },
{ SM_CONF_DEF_MAGIC, "key_file",	sm_conf_type_string,
	offsetof(ss_cnf_T, ss_cnf_key),	0,
	SM_MTA_KEY,
	0,	NULL,	NULL,	NULL,
	"File with private key for certificate in PEM format" },
{ SM_CONF_DEF_MAGIC, "DSA_cert_file",	sm_conf_type_string,
	offsetof(ss_cnf_T, ss_cnf_dsa_cert),	0,
	NULL,	0,	NULL,	NULL,	NULL,
	"File with DSA certificate in PEM format" },
{ SM_CONF_DEF_MAGIC, "DSA_key_file",	sm_conf_type_string,
	offsetof(ss_cnf_T, ss_cnf_dsa_key),	0,
	NULL,	0,	NULL,	NULL,	NULL,
	"File with private key for DSA certificate in PEM format" },
{ SM_CONF_DEF_MAGIC, "CAcert_file",	sm_conf_type_string,
	offsetof(ss_cnf_T, ss_cnf_cacert),	0,
	SM_MTA_CACERT,
	0,	NULL,	NULL,	NULL,
	"File with CA certificate in PEM format" },
{ SM_CONF_DEF_MAGIC, "CAcert_directory",	sm_conf_type_string,
	offsetof(ss_cnf_T, ss_cnf_certpath),	0,
	SM_MTA_CERTP,
	0,	NULL,	NULL,	NULL,
	"Directory with (symbolic links for) CA certificates in PEM format" },

{ SM_CONF_DEF_MAGIC, "flags",		sm_conf_type_choice,
	offsetof(ss_cnf_T, ss_cnf_cflags),	sizeof(uint32_t),
	NULL, SM_CONF_FLAG_MULTIPLE, ss_tls_flag_names,
	NULL,	NULL,
	"flags to influence behavior related to STARTTLS [see documentation]" },

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_SSCNFDEF */
;
#endif /* SM_USE_TLS */


#if SM_USE_SASL
EXTERN
sm_conf_definition_T
ss_auth_defs[]
#if SM_SSCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, "flags",		sm_conf_type_choice,
	offsetof(ss_cnf_T, ss_cnf_auth_flags),	sizeof(uint32_t),
	NULL, SM_CONF_FLAG_MULTIPLE, ss_auth_flag_names,
	NULL,	NULL,
	"Flags for Cyrus SASL (AUTH)"	},
{ SM_CONF_DEF_MAGIC, "trusted_mechanisms",	sm_conf_type_string,
	offsetof(ss_cnf_T, ss_cnf_trusted_mechs),	0,
	"PLAIN LOGIN DIGEST-MD5 CRAM-MD5",
	0,	NULL,	NULL,	NULL,
	"List of SASL mechanisms for which relaying is allowed if a client "
	"successfully authenticated using one of those" },

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_SSCNFDEF */
;
#endif /* SM_USE_SASL */


#if SM_USE_PMILTER
EXTERN
sm_conf_definition_T
ss_pmilter_defs[]
#if SM_SSCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, "socket",	sm_conf_type_union,
	offsetof(ss_cnf_T, ss_cnf_miltsockspec.sckspc_type),
	sizeof(sockspec_T),
	"unix", SM_CONF_FLAG_KEEP_DEFAULT, sock_spec_definitions,
	NULL, NULL,
	"socket for communication with pmilter" },

{ SM_CONF_DEF_MAGIC, "timeout",		sm_conf_type_u32,
	offsetof(ss_cnf_T, ss_cnf_w4m2s),	sizeof(uint),
	SM_XSTR(TMO_W4M2S),	0,	sm_conf_time_suffixes,
	NULL,	NULL,
	"maximum amount of time to wait for a reply from a policy milter" },

{ SM_CONF_DEF_MAGIC, "flags",		sm_conf_type_choice,
	offsetof(ss_cnf_T, ss_cnf_mflags),	sizeof(uint32_t),
	NULL, SM_CONF_FLAG_MULTIPLE, ss_pm_flag_names,
	NULL,	NULL,
	"policy milter flags [see documentation]"	},

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_SSCNFDEF */
;
#endif /* SM_USE_PMILTER */




EXTERN
sm_conf_definition_T
ss_defs[]
#if SM_SSCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, "pass_fd_socket",	sm_conf_type_string,
	offsetof(ss_cnf_T, ss_cnf_fd_socket),	0,
	NULL,			SM_CONF_FLAG_KEEP_DEFAULT,
	NULL,	NULL,	NULL,
	"path of Unix domain socket to exchange file descriptor [use with MCP]"
	},

{ SM_CONF_DEF_MAGIC, "daemon_address",		sm_conf_type_argv,
	offsetof(ss_cnf_T, ss_cnf_sck_addr),	SS_MAX_BIND_ADDRS,	NULL,
	0,	NULL,	NULL,	NULL,
	"address for daemon to listen on [do not use with MCP]"	},

{ SM_CONF_DEF_MAGIC, "listen_queue",		sm_conf_type_u32,
	offsetof(ss_cnf_T, ss_cnf_listenq_size),	sizeof(int),
	SM_XSTR(LISTENQ_SIZE_DEFAULT),	SM_CONF_FLAG_KEEP_DEFAULT,
	NULL,	NULL,	NULL,
	"length of listen(2) queue [do not use with MCP]"	},

#if SS_LOGDIR
{ SM_CONF_DEF_MAGIC, "log_directory",	sm_conf_type_string,
	offsetof(ss_cnf_T, ss_cnf_logdir),	0,
	NULL,			SM_CONF_FLAG_KEEP_DEFAULT,
	NULL,	NULL,	NULL,
	"Directory for logfiles"	},
#endif /* SS_LOGDIR */
{ SM_CONF_DEF_MAGIC, "log_level",		sm_conf_type_u32,
	offsetof(ss_cnf_T, ss_cnf_loglevel),	sizeof(uint),
	SM_XSTR(SM_LOG_LEVEL),	0,	NULL,	NULL,	NULL,
	"log level"	},
{ SM_CONF_DEF_MAGIC, "log", sm_conf_type_section,
	offsetof(ss_cnf_T, ss_cnf_log),		0,
	NULL, SM_CONF_FLAG_KEEP_DEFAULT, sm_log_spec_defs,
	NULL,	NULL,
	SM_CNF_LOG	},

{ SM_CONF_DEF_MAGIC, "relay_from",	sm_conf_type_string,
	offsetof(ss_cnf_T, ss_cnf_relay_from),	0,
	RELAY_CLT,			SM_CONF_FLAG_KEEP_DEFAULT,
	NULL,	NULL,	NULL,
	"allow relaying from IPv4 addresses that match this regular expression"},
{ SM_CONF_DEF_MAGIC, "relay_to",	sm_conf_type_string,
	offsetof(ss_cnf_T, ss_cnf_relay_to),	0,
	RELAY_RCPT,			SM_CONF_FLAG_KEEP_DEFAULT,
	NULL,	NULL,	NULL,
	"allow relaying to addresses that match this regular expression" },

{ SM_CONF_DEF_MAGIC, "cdb_gid",		sm_conf_type_u32,
	offsetof(ss_cnf_T, ss_cnf_cdb_gid),	sizeof(gid_t),
	"0",	SM_CONF_FLAG_KEEP_DEFAULT,
	NULL,	NULL,	NULL,
	"group id (numeric) to use for CDB files"	},

{ SM_CONF_DEF_MAGIC, "id",		sm_conf_type_u32,
	offsetof(ss_cnf_T, ss_cnf_id_base),	sizeof(uint),
	"0",	SM_CONF_FLAG_KEEP_DEFAULT,
	NULL,	NULL,	NULL,
	"(unique) id for server (if multiple SMTP servers are configured)" },

{ SM_CONF_DEF_MAGIC, "max_transactions",	sm_conf_type_u32,
	offsetof(ss_cnf_T, ss_cnf_t_tot_lim),	sizeof(uint),
	SM_XSTR(SM_MAX_TAS),	SM_CONF_FLAG_KEEP_DEFAULT,
	NULL,	NULL,	NULL,
	"maximum number of transactions per session"	},

{ SM_CONF_DEF_MAGIC, "max_recipients_per_session",	sm_conf_type_u32,
	offsetof(ss_cnf_T, ss_cnf_r_tot_lim),	sizeof(uint),
	SM_XSTR(SM_MAX_RCPTS),	SM_CONF_FLAG_KEEP_DEFAULT,
	NULL,	NULL,	NULL,
	"maximum number of recipients per session"	},

{ SM_CONF_DEF_MAGIC, "max_recipients_per_transaction",	sm_conf_type_u32,
	offsetof(ss_cnf_T, ss_cnf_r_ta_lim),	sizeof(uint),
	SM_XSTR(SM_MAX_RCPTS),	SM_CONF_FLAG_KEEP_DEFAULT,
	NULL,	NULL,	NULL,
	"maximum number of recipients per transaction"	},

{ SM_CONF_DEF_MAGIC, "max_hops",		sm_conf_type_u32,
	offsetof(ss_cnf_T, ss_cnf_maxhops),	sizeof(uint),
	SM_XSTR(SM_MAXHOPS),	SM_CONF_FLAG_KEEP_DEFAULT,
	NULL,	NULL,	NULL,
	"maximum number of hops (Received: headers)"	},

{ SM_CONF_DEF_MAGIC, "max_message_size",	sm_conf_type_u32,
	offsetof(ss_cnf_T, ss_cnf_max_msg_sz_kb),	sizeof(uint),
	SM_XSTR(SM_MAX_MSG_SZ_KB),	SM_CONF_FLAG_KEEP_DEFAULT,
	sm_conf_Kbyte_suffixes,	NULL,	NULL,
	"maximum message size (KB)"	},

{ SM_CONF_DEF_MAGIC, "max_bad_commands_per_session",	sm_conf_type_u32,
	offsetof(ss_cnf_T, ss_cnf_sess_max_badcmds),	sizeof(uint),
	SM_XSTR(SS_SESS_MAX_BADCMDS),	SM_CONF_FLAG_KEEP_DEFAULT,
	NULL,	NULL,	NULL,
	"maximum number of bad SMTP commands per session"	},

{ SM_CONF_DEF_MAGIC, "max_invalid_addresses_per_session", sm_conf_type_u32,
	offsetof(ss_cnf_T, ss_cnf_sess_max_invldaddr),	sizeof(uint),
	SM_XSTR(SS_SESS_MAX_INVLDADDR),	SM_CONF_FLAG_KEEP_DEFAULT,
	NULL,	NULL,	NULL,
	"maximum number of SMTP commands with invalid addresses per session" },

{ SM_CONF_DEF_MAGIC, "max_nop_commands_between_transactions", sm_conf_type_u32,
	offsetof(ss_cnf_T, ss_cnf_sess_max_nopcmds),	sizeof(uint),
	SM_XSTR(SS_SESS_MAX_NOPCMDS),	SM_CONF_FLAG_KEEP_DEFAULT,
	NULL,	NULL,	NULL,
	"maximum number of nop SMTP commands between transactions"	},

{ SM_CONF_DEF_MAGIC, "max_bad_commands_per_transaction", sm_conf_type_u32,
	offsetof(ss_cnf_T, ss_cnf_ta_max_badcmds),	sizeof(uint),
	SM_XSTR(SS_TA_MAX_BADCMDS),	SM_CONF_FLAG_KEEP_DEFAULT,
	NULL,	NULL,	NULL,
	"maximum number of bad SMTP commands per transaction"	},

{ SM_CONF_DEF_MAGIC, "max_nop_commands_in_transaction", sm_conf_type_u32,
	offsetof(ss_cnf_T, ss_cnf_ta_max_nopcmds),	sizeof(uint),
	SM_XSTR(SS_TA_MAX_NOPCMDS),	SM_CONF_FLAG_KEEP_DEFAULT,
	NULL,	NULL,	NULL,
	"maximum number of nop SMTP commands in a single transaction"	},

{ SM_CONF_DEF_MAGIC, "max_invalid_addresses_per_transaction", sm_conf_type_u32,
	offsetof(ss_cnf_T, ss_cnf_ta_max_invldaddr),	sizeof(uint),
	SM_XSTR(SS_TA_MAX_INVLDADDR),	SM_CONF_FLAG_KEEP_DEFAULT,
	NULL,	NULL,	NULL,
	"maximum number of SMTP commands with invalid addresses per transaction" },

{ SM_CONF_DEF_MAGIC, "io_timeout",	sm_conf_type_u32,
	offsetof(ss_cnf_T, ss_cnf_timeout),	sizeof(sm_intvl_T),
	SM_XSTR(SS_IO_TIMEOUT),		SM_CONF_FLAG_KEEP_DEFAULT,
	sm_conf_time_suffixes, NULL,	NULL,
	"timeout for SMTP I/O operations"	},

{ SM_CONF_DEF_MAGIC, "flags",		sm_conf_type_choice,
	offsetof(ss_cnf_T, ss_cnf_cflags),	sizeof(uint32_t),
	NULL, SM_CONF_FLAG_MULTIPLE, ss_flag_names,
	NULL,	NULL,
	"flags to influence behavior [see documentation]"	},

{ SM_CONF_DEF_MAGIC, SS_PR_CNF,		sm_conf_type_section,
	0,				sizeof(uint32_t),
	NULL, SM_CONF_FLAG_KEEP_DEFAULT,	ss_protrcpt_defs,
	NULL,	NULL,
	"how to protect recipient addresses [see documentation]"	},

{ SM_CONF_DEF_MAGIC, "max_threads",		sm_conf_type_u32,
	offsetof(ss_cnf_T, ss_cnf_max_threads),	sizeof(uint),
	"0",		SM_CONF_FLAG_KEEP_DEFAULT,
	NULL,	NULL,	NULL,
	"maximum number of threads"	},

{ SM_CONF_DEF_MAGIC, "max_wait_threads",	sm_conf_type_u32,
	offsetof(ss_cnf_T, ss_cnf_max_wait_threads),	sizeof(uint),
	"8",	SM_CONF_FLAG_KEEP_DEFAULT,	NULL,	NULL,	NULL,
	"maximum number of waiting threads"	},

{ SM_CONF_DEF_MAGIC, "min_wait_threads",	sm_conf_type_u32,
	offsetof(ss_cnf_T, ss_cnf_min_wait_threads),	sizeof(uint),
	"2",	SM_CONF_FLAG_KEEP_DEFAULT,	NULL,	NULL,	NULL,
	"minimum number of waiting threads"	},

{ SM_CONF_DEF_MAGIC, "processes",		sm_conf_type_u32,
	offsetof(ss_cnf_T, ss_cnf_vp_count),	sizeof(int),
	"1",	SM_CONF_FLAG_KEEP_DEFAULT,	NULL,	NULL,	NULL,
	"number of processes to start"	},

{ SM_CONF_DEF_MAGIC, "wait_for_server",		sm_conf_type_u32,
	offsetof(ss_cnf_T, ss_cnf_wait4srv),	sizeof(uint),
	"1",	0,	sm_conf_time_suffixes,
	NULL,	NULL,
	"maximum amount of time to wait for a server to become available" },

{ SM_CONF_DEF_MAGIC, "wait_for_smar",		sm_conf_type_u32,
	offsetof(ss_cnf_T, ss_cnf_w4a2s),	sizeof(uint),
	SM_XSTR(TMO_W4A2S),	0,	sm_conf_time_suffixes,
	NULL,	NULL,
	"maximum amount of time to wait for a reply from smar" },

{ SM_CONF_DEF_MAGIC, "debug_level",		sm_conf_type_u32,
	offsetof(ss_cnf_T, ss_cnf_debug),	sizeof(uint),
	"0",	0,	NULL,	NULL,	NULL,
	"debug level"	},

#if SM_USE_TLS
{ SM_CONF_DEF_MAGIC, "tls", sm_conf_type_section,
	0, sizeof(ss_cnf_T), NULL,
	SM_CONF_FLAG_KEEP_DEFAULT,
	ss_tls_defs,
	NULL, NULL, NULL },
#endif /* SM_USE_TLS */

#if SM_USE_SASL
{ SM_CONF_DEF_MAGIC, "auth", sm_conf_type_section,
	0, sizeof(ss_cnf_T), NULL,
	SM_CONF_FLAG_KEEP_DEFAULT,
	ss_auth_defs,
	NULL, NULL, NULL },
#endif /* SM_USE_SASL */

#if SM_USE_PMILTER
{ SM_CONF_DEF_MAGIC, "pmilter", sm_conf_type_section,
	0, sizeof(ss_cnf_T), NULL,
	SM_CONF_FLAG_KEEP_DEFAULT|SM_CONF_FLAG_DPRCD,
	ss_pmilter_defs,
	NULL, NULL,
	"policy milter" },
{ SM_CONF_DEF_MAGIC, "policy_milter", sm_conf_type_section,
	0, sizeof(ss_cnf_T), NULL,
	SM_CONF_FLAG_KEEP_DEFAULT,
	ss_pmilter_defs,
	NULL, NULL,
	"policy milter" },
#endif /* SM_USE_PMILTER */

	MCP_SRV_DEFS(ss_cnf_T, ss_cnf),
	MCP_DEFS(ss_cnf_T, ss_cnf)

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_SSCNFDEF */
;

EXTERN
sm_conf_definition_T
ss_global_defs[]
#if SM_SSCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, "SMTPS_socket",	sm_conf_type_string,
	offsetof(ss_cnf_T, ss_cnf_smtpssock),	0,
	smsmtpssock,	SM_CONF_FLAG_KEEP_DEFAULT,
	NULL, NULL, NULL, NULL },
{ SM_CONF_DEF_MAGIC, "SMAR_socket",	sm_conf_type_string,
	offsetof(ss_cnf_T, ss_cnf_smarsock),	0,
	smarsock,	SM_CONF_FLAG_KEEP_DEFAULT,
	NULL, NULL, NULL, NULL },
{ SM_CONF_DEF_MAGIC, "CDB_base_directory",	sm_conf_type_string,
	offsetof(ss_cnf_T, ss_cnf_cdb_base),	0,
	"",		SM_CONF_FLAG_KEEP_DEFAULT,
	NULL, NULL, NULL, NULL },
{ SM_CONF_DEF_MAGIC, "hostname",		sm_conf_type_string,
	offsetof(ss_cnf_T, ss_cnf_hostname),	0,	NULL,
	0, NULL, NULL, NULL, NULL },

{ SM_CONF_DEF_MAGIC, "smtps", sm_conf_type_section,
	0, sizeof(ss_cnf_T), NULL,
	SM_CONF_FLAG_KEEP_DEFAULT|SM_CONF_FLAG_MULTIPLE|SM_CONF_FLAG_PARSE_ONLY,
	ss_defs,
	NULL, NULL, NULL },

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_SSCNFDEF */
;

#undef EXTERN

#endif /* SM_SSCNFDEF_H */
