/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: smardef.h,v 1.8 2005/08/11 17:48:19 ca Exp $
 */

#ifndef SM_SMARDEF_H
#define SM_SMARDEF_H 1

/*
**  Definitions for smar
*/

#define SMAR_CNF_MINTHR	2	/* min number of threads */
#define SMAR_CNF_MAXTHR	16	/* max number of threads */
#define SMAR_CNF_MAXFD	10	/* max number of file descriptors (clients) */

/* default for address delimiter */
#define SM_ADDR_DELIM	((uchar) '+')

#define SMAR_MT_TYPE	"bhtable"
#define SMAR_MT_NAME	"mt"

#define SMAR_ALIASES_TYPE	"hash"
#define SMAR_ALIASES_NAME	"aliases"
#define SMAR_ALIASES_FILE	"aliases.db"

#define SMARCNF_FL_ALI_LP	0x00000001 /* local part only */
#define SMARCNF_FL_ALI_LD	0x00000002 /* local aliases incl. domain */
#define SMARCNF_FL_ALI_ALL	0x00000004 /* remote aliases */
#define SMARCNF_FL_ALI_DETPLUS	0x00000010 /* user++ lookup */
#define SMARCNF_FL_ALI_DETSTAR	0x00000020 /* user+* lookup */
#define SMARCNF_FL_ALI_STAR	0x00000040 /* user* lookup */
#define SMARCNF_FL_ALI_DOMAIN	0x00000080 /* domain */
#define SMARCNF_FL_ALI_DOTSUBDOM 0x00000100 /* .sub.domain */
#define SMARCNF_FL_ALI_IMPLDET	0x00000200 /* user+detail matches user */
#define SMARCNF_FL_ALI_MREPL	0x00000400

#define SMARCNF_FL_ALI_PD	0x00001000 /* preserve original domain */

#define SMAR_ACCESS_TYPE	"hash"
#define SMAR_ACCESS_NAME	"access"
#define SMAR_ACCESS_FILE	"access.db"

#endif /* SM_SMARDEF_H */
