/*
 * Copyright (c) 2002-2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: net.h,v 1.21 2005/06/30 19:56:01 ca Exp $
 */

#ifndef SM_NET_H
#define SM_NET_H 1

#include "sm/generic.h"
#include "sm/types.h"
#include "sm/str.h"

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/un.h>

/* XXX This should be in_addr */
typedef uint32_t ipv4_T;

/* compare two IPv4 addresses; need later on generic address comparison macro */
#define ipv4_addr_eq(a1, a2)	((a1) == (a2))

#define sockaddr_len_T socklen_T

/* generic Unix sockaddr structure */
typedef struct sockaddr		sockaddr_T, *sockaddr_P;

/* Unix sockaddr structure for IPv4 */
typedef struct sockaddr_in	sockaddr_in_T, *sockaddr_in_P;

typedef struct in_addr		in_addr_T, *in_addr_P;

/*
**  generic sockaddr structure for sendmail
**  make parts of this conditional, compare sendmail8/sendmail/sendmail.h
*/

union sm_sockaddr_U
{
	struct sockaddr		sa;	/* general version */
	struct sockaddr_un	sunix;	/* UNIX family */
	struct sockaddr_in	sin;	/* INET family */
};

typedef union sm_sockaddr_U	sm_sockaddr_T, *sm_sockaddr_P;

/* XXX */
#define closesocket close

#define INVALID_SOCKET (-1)
#define is_valid_socket(fd)	((fd) >= 0)
#define CLOSE_SOCKET(fd)	do			\
		{					\
			if (is_valid_socket(fd))	\
			{				\
				close(fd);		\
				(fd) = INVALID_SOCKET;	\
			}				\
		} while (0)

#ifndef INADDR_NONE
# define INADDR_NONE	0xffffffff
#endif

#ifndef INADDR_LOOPBACK
# define INADDR_LOOPBACK	0x7f000001
#endif

sm_ret_T net_client_connect(const char *_ip, int _port, int *pfd);
sm_ret_T net_client_connectipv4(ipv4_T ipv4, int port, int *pfd);
int	net_server_listen_addr(sockaddr_T *_addr, int _addrlen, int _backlog);
sm_ret_T net_server_listen(const char *_ip, int _port, int _backlog);
sm_ret_T net_server_accept(int _listenfd, sockaddr_T *_addr, sockaddr_len_T *_addrlen);

sm_ret_T sm_inet_a2ipv4(const char *_cp, char **_endptr, ipv4_T *_ipv4);
sm_ret_T sm_inet_ipv4str(ipv4_T _ipv4, sm_str_P _dst);
sm_ret_T sm_inet_inaddr2str(in_addr_T _inaddr, sm_str_P _dst);
sm_ret_T sm_inet_ipv42arpastr(ipv4_T _ipv4, sm_str_P _dst);
sm_ret_T sm_inet_inaddr2arpastr(struct in_addr _inaddr, sm_str_P _dst);
sm_ret_T sm_inet_arpa2ipv4(const char *_cp, ipv4_T *_ipv4);

#endif /* SM_NET_H */
