/*
 * Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: mapc.h,v 1.18 2005/10/13 21:01:48 ca Exp $
 */

#ifndef SM_MAPC_H
#define SM_MAPC_H 1

#include "sm/generic.h"
#include "sm/types.h"
#include "sm/varargs.h"
#include "sm/magic.h"
#include "sm/cstr.h"
#include "sm/time.h"
#include "sm/map-str.h"

typedef sm_ret_T (*sm_map_create_F)(sm_mapc_P _mapc, sm_cstr_P _type, uint32_t _flags, sm_map_P _map);
typedef sm_ret_T (*sm_map_open_F)(sm_mapc_P _mapc, const sm_cstr_P _type, uint32_t _flags, const char *_path, int _mode, sm_map_P _map, va_list _ap);
typedef sm_ret_T (*sm_map_close_F)(sm_map_P _map, uint32_t _flags);
typedef sm_ret_T (*sm_map_reopen_F)(sm_map_P _map, uint32_t _flags);
typedef sm_ret_T (*sm_map_destroy_F)(sm_map_P _map, uint32_t _flags);
typedef sm_ret_T (*sm_map_add_F)(sm_map_P _map, sm_map_key_P _key, sm_map_data_P _data, uint _flags);
typedef sm_ret_T (*sm_map_rm_F)(sm_map_P _map, sm_map_key_P _key);
typedef sm_ret_T (*sm_map_alloc_F)(sm_map_P _map, sm_map_entry_P *_pentry);
typedef sm_ret_T (*sm_map_free_F)(sm_map_P _map, sm_map_entry_P _entry);
typedef sm_ret_T (*sm_map_lookup_F)(sm_map_P _map, uint32_t _flags, sm_map_key_P _key, sm_map_data_P _data);
typedef sm_ret_T (*sm_map_locate_F)(sm_map_P _map, uint32_t _flags, sm_map_key_P _key, sm_map_entry_P *_pentry);
typedef sm_ret_T (*sm_map_first_F)(sm_map_P _map, sm_map_cursor_P *_pmap_cursor, sm_map_entry_P *_pentry);
typedef sm_ret_T (*sm_map_next_F)(sm_map_P _map, sm_map_cursor_P *_pmap_cursor, sm_map_entry_P *_pentry);

typedef sm_ret_T (*sm_map_setopt_F)(sm_map_P _map, va_list _ap);
typedef sm_ret_T (*sm_map_getopt_F)(sm_map_P _map, int _what, void *_valp);

#if 0
#define SM_MAPC_STRUCT(type, flags, open, close, add, rm, alloc, free, lookup, locate, first, next) \
    {SM_MAPC_MAGIC, (type), (flags), , (open), (close), \
	(add), (rm), (alloc), (free), (lookup), (locate), (first), (next) }
#endif /* 0 */


struct sm_mapc_S
{
#if SM_MAP_CHECK
	sm_magic_T		 sm_magic;
#endif
	sm_maps_P		 sm_mapc_maps;	/* map system context */
	sm_cstr_P		 sm_mapc_type;
	uint32_t		 sm_mapc_flags;

	sm_map_create_F		 sm_mapc_createf;
	sm_map_open_F		 sm_mapc_openf;
	sm_map_close_F		 sm_mapc_closef;
	sm_map_reopen_F		 sm_mapc_reopenf;
	sm_map_destroy_F	 sm_mapc_destroyf;
	sm_map_add_F		 sm_mapc_addf;
	sm_map_rm_F		 sm_mapc_rmf;
	sm_map_alloc_F		 sm_mapc_allocf;
	sm_map_free_F		 sm_mapc_freef;
	sm_map_lookup_F		 sm_mapc_lookupf;
	sm_map_locate_F		 sm_mapc_locatef;
	sm_map_first_F		 sm_mapc_firstf;
	sm_map_next_F		 sm_mapc_nextf;
	sm_map_setopt_F		 sm_mapc_setoptf;
	sm_map_getopt_F		 sm_mapc_getoptf;
};

/* flags for map context */
#define SMMAPC_FL_NONE		0x00000000u
#define SMMAPC_FL_ALLOC_K	0x00000001u /* can allocate key */
#define SMMAPC_FL_ALLOC_D	0x00000002u /* can allocate data */
#define SMMAPC_FL_FREE_K	0x00000004u /* can free key */
#define SMMAPC_FL_FREE_D	0x00000008u /* can free data */
#define SMMAPC_FL_GEN_REOPEN	0x00000010u /* use generic map reload fct */

/*
**  What kind of locking is required? Note: this may depend on the mode in
**  which the map has been opened (R/W or RD), hence it should be an
**  option for open() instead of create()?
*/

#define SMMAPC_FL_LCK_WR	0x00000020u /* use write/read locking */
#define SMMAPC_FL_LCK_FULL	0x00000040u /* full locking for every access */

sm_ret_T	 sm_mapc_create(
			sm_maps_P	 _maps,
			sm_cstr_P	 _sm_mapc_type,
			uint32_t	 _sm_mapc_flags,
			sm_map_create_F	 _sm_mapc_createf,
			sm_map_open_F	 _sm_mapc_openf,
			sm_map_close_F	 _sm_mapc_closef,
			sm_map_reopen_F	 _sm_mapc_reopenf,
			sm_map_destroy_F _sm_mapc_destroyf,
			sm_map_add_F	 _sm_mapc_addf,
			sm_map_rm_F	 _sm_mapc_rmf,
			sm_map_alloc_F	 _sm_mapc_allocf,
			sm_map_free_F	 _sm_mapc_freef,
			sm_map_lookup_F	 _sm_mapc_lookupf,
			sm_map_locate_F	 _sm_mapc_locatef,
			sm_map_first_F	 _sm_mapc_firstf,
			sm_map_next_F	 _sm_mapc_nextf,
			sm_map_setopt_F	 _sm_mapc_setoptf,
			sm_map_getopt_F	 _sm_mapc_getoptf,
			sm_mapc_P	 *_pmapc);

#if SM_MAP_CHECK
# define SM_IS_MAPC(mapc)	SM_REQUIRE_ISA((mapc), SM_MAPC_MAGIC)
#else
# define SM_IS_MAPC(mapc)	SM_REQUIRE((mapc) != NULL)
#endif

#endif /* SM_MAPC_H */
