/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: logcnfdef.h,v 1.8 2005/06/09 23:34:38 ca Exp $
 */

#ifndef SM_LOGCNFDEF_H
#define SM_LOGCNFDEF_H 1

#include "sm/generic.h"
#include "sm/syslog.h"
#include "sm/sm-conf.h"

#if SM_CONF_LOG_DEF
#define EXTERN
#else /* SM_CONF_LOG_DEF */
#define EXTERN extern
#endif /* SM_CONF_LOG_DEF */

typedef struct sm_logspec_S sm_logspec_T, *sm_logspec_P;
struct sm_logspec_S
{
	int	 sm_logspc_opt;
	int	 sm_logspc_facility;
	char	*sm_logspc_ident;
};

EXTERN
sm_conf_definition_T const sm_log_opts[]
#if SM_CONF_LOG_DEF
=
{
#ifdef LOG_CONS
	{ SM_CONF_DEF_MAGIC,
	"cons",		sm_conf_type_choice_value,	LOG_CONS,
	0, NULL, 0, NULL, NULL, NULL, NULL },
#endif
#ifdef LOG_NDELAY
	{ SM_CONF_DEF_MAGIC,
	"ndelay",	sm_conf_type_choice_value,	LOG_NDELAY,
	0, NULL, 0, NULL, NULL, NULL, NULL },
#endif
#ifdef LOG_PERROR
	{ SM_CONF_DEF_MAGIC,
	"perror",	sm_conf_type_choice_value,	LOG_PERROR,
	0, NULL, 0, NULL, NULL, NULL, NULL },
#endif
#ifdef LOG_PID
	{ SM_CONF_DEF_MAGIC,
	"pid",		sm_conf_type_choice_value,	LOG_PID,
	0, NULL, 0, NULL, NULL, NULL, NULL },
#endif

	/* Sentinel */
	{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_CONF_LOG_DEF */
;

/*
created by: lines like this (from syslog.h):
LOG_...
apply:
:'a,.s/LOG_\(.*\)$/#ifdef &
	{ SM_CONF_DEF_MAGIC,
	"\1",	sm_conf_type_choice_value,		&	},
#endif/
*/

EXTERN
sm_conf_definition_T const sm_log_facilities[]
#if SM_CONF_LOG_DEF
=
{
#ifdef LOG_USER
	{ SM_CONF_DEF_MAGIC,
	"USER",	sm_conf_type_choice_value,		LOG_USER,
	0, NULL, 0, NULL, NULL, NULL, NULL },
#endif
#ifdef LOG_MAIL
	{ SM_CONF_DEF_MAGIC,
	"MAIL",	sm_conf_type_choice_value,		LOG_MAIL,
	0, NULL, 0, NULL, NULL, NULL, NULL },
#endif
#ifdef LOG_DAEMON
	{ SM_CONF_DEF_MAGIC,
	"DAEMON",	sm_conf_type_choice_value,	LOG_DAEMON,
	0, NULL, 0, NULL, NULL, NULL, NULL },
#endif
#ifdef LOG_AUTH
	{ SM_CONF_DEF_MAGIC,
	"AUTH",	sm_conf_type_choice_value,		LOG_AUTH,
	0, NULL, 0, NULL, NULL, NULL, NULL },
#endif
#if 0
/* Messages generated internally by syslogd(8). */
#ifdef LOG_SYSLOG
	{ SM_CONF_DEF_MAGIC,
	"SYSLOG",	sm_conf_type_choice_value,	LOG_SYSLOG,
	0, NULL, 0, NULL, NULL, NULL, NULL },
#endif
#endif /* 0 */
#ifdef LOG_LPR
	{ SM_CONF_DEF_MAGIC,
	"LPR",	sm_conf_type_choice_value,		LOG_LPR,
	0, NULL, 0, NULL, NULL, NULL, NULL },
#endif
#ifdef LOG_NEWS
	{ SM_CONF_DEF_MAGIC,
	"NEWS",	sm_conf_type_choice_value,		LOG_NEWS,
	0, NULL, 0, NULL, NULL, NULL, NULL },
#endif
#ifdef LOG_UUCP
	{ SM_CONF_DEF_MAGIC,
	"UUCP",	sm_conf_type_choice_value,		LOG_UUCP,
	0, NULL, 0, NULL, NULL, NULL, NULL },
#endif
#ifdef LOG_CRON
	{ SM_CONF_DEF_MAGIC,
	"CRON",	sm_conf_type_choice_value,		LOG_CRON,
	0, NULL, 0, NULL, NULL, NULL, NULL },
#endif
#ifdef LOG_AUTHPRIV
	{ SM_CONF_DEF_MAGIC,
	"AUTHPRIV",	sm_conf_type_choice_value,	LOG_AUTHPRIV,
	0, NULL, 0, NULL, NULL, NULL, NULL },
#endif
#ifdef LOG_FTP
	{ SM_CONF_DEF_MAGIC,
	"FTP",	sm_conf_type_choice_value,		LOG_FTP,
	0, NULL, 0, NULL, NULL, NULL, NULL },
#endif
#ifdef LOG_NTP
	{ SM_CONF_DEF_MAGIC,
	"NTP",	sm_conf_type_choice_value,		LOG_NTP,
	0, NULL, 0, NULL, NULL, NULL, NULL },
#endif
#ifdef LOG_SECURITY
	{ SM_CONF_DEF_MAGIC,
	"SECURITY",	sm_conf_type_choice_value,	LOG_SECURITY,
	0, NULL, 0, NULL, NULL, NULL, NULL },
#endif
#ifdef LOG_CONSOLE
	{ SM_CONF_DEF_MAGIC,
	"CONSOLE",	sm_conf_type_choice_value,	LOG_CONSOLE,
	0, NULL, 0, NULL, NULL, NULL, NULL },
#endif
#ifdef LOG_LOCAL0
	{ SM_CONF_DEF_MAGIC,
	"LOCAL0",	sm_conf_type_choice_value,	LOG_LOCAL0,
	0, NULL, 0, NULL, NULL, NULL, NULL },
#endif
#ifdef LOG_LOCAL1
	{ SM_CONF_DEF_MAGIC,
	"LOCAL1",	sm_conf_type_choice_value,	LOG_LOCAL1,
	0, NULL, 0, NULL, NULL, NULL, NULL },
#endif
#ifdef LOG_LOCAL2
	{ SM_CONF_DEF_MAGIC,
	"LOCAL2",	sm_conf_type_choice_value,	LOG_LOCAL2,
	0, NULL, 0, NULL, NULL, NULL, NULL },
#endif
#ifdef LOG_LOCAL3
	{ SM_CONF_DEF_MAGIC,
	"LOCAL3",	sm_conf_type_choice_value,	LOG_LOCAL3,
	0, NULL, 0, NULL, NULL, NULL, NULL },
#endif
#ifdef LOG_LOCAL4
	{ SM_CONF_DEF_MAGIC,
	"LOCAL4",	sm_conf_type_choice_value,	LOG_LOCAL4,
	0, NULL, 0, NULL, NULL, NULL, NULL },
#endif
#ifdef LOG_LOCAL5
	{ SM_CONF_DEF_MAGIC,
	"LOCAL5",	sm_conf_type_choice_value,	LOG_LOCAL5,
	0, NULL, 0, NULL, NULL, NULL, NULL },
#endif
#ifdef LOG_LOCAL6
	{ SM_CONF_DEF_MAGIC,
	"LOCAL6",	sm_conf_type_choice_value,	LOG_LOCAL6,
	0, NULL, 0, NULL, NULL, NULL, NULL },
#endif
#ifdef LOG_LOCAL7
	{ SM_CONF_DEF_MAGIC,
	"LOCAL7",	sm_conf_type_choice_value,	LOG_LOCAL7,
	0, NULL, 0, NULL, NULL, NULL, NULL },
#endif

	/* Sentinel */
	{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_CONF_LOG_DEF */
;

EXTERN
sm_conf_definition_T sm_log_spec_defs[]
#if SM_CONF_LOG_DEF
=
{
	{ SM_CONF_DEF_MAGIC, "options",		sm_conf_type_choice,
		offsetof(sm_logspec_T, sm_logspc_opt),	sizeof(int),
		NULL, SM_CONF_FLAG_MULTIPLE, sm_log_opts,
		NULL,	NULL,
		"options for openlog(3)"
	},

	{ SM_CONF_DEF_MAGIC, "facility",	sm_conf_type_choice,
		offsetof(sm_logspec_T, sm_logspc_facility),	sizeof(int),
		NULL, 0,		sm_log_facilities,
		NULL,	NULL,
		"facility for openlog(3)"
	},

	{ SM_CONF_DEF_MAGIC, "ident",		sm_conf_type_string,
		offsetof(sm_logspec_T, sm_logspc_ident),	0,
#ifdef SM_LOG_IDENT
		SM_LOG_IDENT
#else /* SM_LOG_IDENT */
		NULL
#endif /* SM_LOG_IDENT */
		, 0,	NULL,	NULL,	NULL,
		"ident for openlog(3)"
	},

	/* Sentinel */
	{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_CONF_LOG_DEF */
;

#undef EXTERN

#endif /* SM_LOGCNFDEF_H */
