/*
 * Copyright (c) 2002-2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: generic.h,v 1.27 2005/08/24 22:48:29 ca Exp $
 */

/*
**  This file includes basic definitions.
*/

#ifndef SM_GENERIC_H
#define SM_GENERIC_H 1

/*
**  Define SM_UNUSED, a macro used to declare variables that may be unused.
*/

#ifndef SM_UNUSED
# if __GNUC__ >= 2
#  if __GNUC__ == 2 && __GNUC_MINOR__ < 7
#   define SM_UNUSED(decl) decl
#  else /* __GNUC__ == 2 && __GNUC_MINOR__ < 7 */
#   define SM_UNUSED(decl) decl __attribute__((__unused__))
#  endif /* __GNUC__ == 2 && __GNUC_MINOR__ < 7 */
# else /* __GNUC__ >= 2 */
#  define SM_UNUSED(decl) decl
# endif /* __GNUC__ >= 2 */
#endif /* ! SM_UNUSED */

/*
**  Define SM_RCSID and SM_IDSTR,
**  macros used to embed RCS and SCCS identification strings in object files.
*/

#ifdef lint
# define SM_RCSID(str)
# define SM_IDSTR(id,str)
#else /* lint */
# define SM_RCSID(str) SM_UNUSED(static const char RcsId[]) = str;
# define SM_IDSTR(id,str) SM_UNUSED(static const char id[]) = str;
#endif /* lint */

/* get configuration options */
#include "smconf.h"
#include "sm/cdefs.h"
#include "sm/types.h"

#if HAVE_SYS_STAT_H
# include <sys/stat.h>
#endif

#if STDC_HEADERS
# include <stdlib.h>
# include <stddef.h>
#else
# if HAVE_STDLIB_H
#  include <stdlib.h>
# endif
#endif

#if HAVE_STRING_H
# if !STDC_HEADERS && HAVE_MEMORY_H
#  include <memory.h>
# endif
# include <string.h>
#endif
#if HAVE_STRINGS_H
# include <strings.h>
#endif

#if HAVE_INTTYPES_H
# include <inttypes.h>
#else
# if HAVE_STDINT_H
#  include <stdint.h>
# endif
#endif
#if HAVE_UNISTD_H
# include <unistd.h>
#endif

/*
**  Define NULL and offsetof (from the C89 standard)
*/

#if HAVE_STDDEF_H
# include <stddef.h>
#else /* HAVE_STDDEF_H */
# ifndef NULL
#  define NULL	((void *)0)
# endif /* ! NULL */
# define offsetof(type, member)	((size_t)(&((type *)0)->member))
#endif /* HAVE_STDDEF_H */

#define NULLPTR	((void *)0)

/*
**  Define bool, true, false (from the C99 standard)
*/

#if HAVE_STDBOOL_H
# include <stdbool.h>
#else /* HAVE_STDBOOL_H */
# ifndef __cplusplus
typedef int bool;
#  define false	0
#  define true	1
# endif /* ! __cplusplus */
#endif /* HAVE_STDBOOL_H */

/* portable(?) definition for alignment */
#ifndef SM_ALIGN_SIZE
struct sm_align
{
	char	al_c;
	union
	{
		long	al_l;
		void	*al_p;
		double	al_d;
		void	(*al_f)(void);
	} al_u;
};
# define SM_ALIGN_SIZE offsetof(struct sm_align, al_u)
#endif /* ! SM_ALIGN_SIZE */
#define SM_ALIGN_BITS (SM_ALIGN_SIZE - 1)

/* align on int32 (4 bytes) */
#define SM_ALIGN4(x)	(((uint32_t)(x) + 3) & ~3)
/* align on size_t */
#define SM_ALIGN4_SIZE(x)	(((size_t)(x) + 3) & ~3)

#define SM_MAX(a, b)	((a) > (b) ? (a) : (b))
#define SM_MIN(a, b)	((a) < (b) ? (a) : (b))

#define SM_SET_FLAG(flags, fl)	(flags) |= (fl)
#define SM_CLR_FLAG(flags, fl)	(flags) &= ~(fl)
#define SM_IS_FLAG(flags, fl)	(((flags) & (fl)) != 0)

#define SM_SUCCESS	0
#define SM_FAILURE	(-1)

#define SM_NOOP	((void) 0)

#ifndef __GNUC__
# define inline
# define __inline__
#endif /* ! __GNUC__ */

/* invalid file descriptor, change for Win32? */
#define INVALID_FD	(-1)
#define is_valid_fd(fd)	((fd) >= 0)
#define CLOSE_FD(fd)	do				\
		{					\
			if (is_valid_fd(fd))		\
			{				\
				close(fd);		\
				(fd) = INVALID_FD;	\
			}				\
		} while (0)

#define SMFCT "undefined"

#define SM_ARRAY_SIZE(array)   (sizeof(array) / sizeof((array)[0]))

/*
**  Macros to convert a constant to a string. Usage:
**
**  #define AQ_SIZE 8192
**
**  { SM_CONF_DEF_MAGIC, "AQ_size",	sm_conf_type_u32,
**  	offsetof(qmgr_conf_T, q_cnf_aq_size),	sizeof(uint),
**  	SM_XSTR(AQ_SIZE)	},
*/

#define SM_STR(x) #x
#define SM_XSTR(x) SM_STR(x)

#if !HAVE_SNPRINTF && !defined(snprintf)
#define snprintf sm_snprintf
#endif

#endif /* SM_GENERIC_H */
