/*
 * Copyright (c) 2002-2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: actdb.h,v 1.51 2005/08/30 17:46:34 ca Exp $
 */

#ifndef SM_ACTDB_H
#define SM_ACTDB_H 1

#include "sm/generic.h"
#include "sm/pthread.h"
#include "sm/queue.h"
#include "sm/mta.h"
#include "sm/log.h"

#ifndef AQ_RDQ
# define AQ_RDQ 1
#endif
#ifndef AQ_WAITQ
# define AQ_WAITQ 1
#endif

typedef struct aq_ctx_S		aq_ctx_T, *aq_ctx_P;
typedef struct aq_mail_S	aq_mail_T, *aq_mail_P;
typedef struct aq_ta_S		aq_ta_T, *aq_ta_P;
typedef struct aq_tas_S		aq_tas_T, *aq_tas_P;
typedef struct aq_dta_S		aq_dta_T, *aq_dta_P;
typedef struct aq_dtas_S	aq_dtas_T, *aq_dtas_P;
typedef struct aq_rcpt_S	aq_rcpt_T, *aq_rcpt_P;
typedef struct aq_rcpts_S	aq_rcpts_T, *aq_rcpts_P;
typedef struct aq_rsnd_ctx_S	aq_rsnd_ctx_T, *aq_rsnd_ctx_P;

TAILQ_HEAD(aq_rcpts_S, aq_rcpt_S);

/* flags for aq_rcpt_rm() */
#define AQR_RM_LOCK	0x0001	/* lock required */
#define AQR_RM_N_RDQ	0x0002	/* don't try to remove from rdq */
#define AQR_RM_N_WAITQ	0x0004	/* don't try to remove from waitq */
#define AQR_RM_I_RDQ	0x0008	/* ignore result from aq_rdq_rm() */
#define AQR_RM_I_WAITQ	0x0010	/* ignore result from aq_waitq_rm() */

sm_ret_T	 aq_rcpt_ss_insert(aq_rcpt_P _aq_rcpt_prev, aq_rcpt_P _aq_rcpt);
sm_ret_T	 aq_rcpt_set_domain(aq_rcpt_P _aq_rcpt);
sm_ret_T	 aq_rcpt_eq_domain(aq_rcpt_P _aq_rcpt1, aq_rcpt_P _aq_rcpt2);
sm_ret_T	 aq_rcpt_new(aq_rcpt_P *_padb_rcpt);
sm_ret_T	 aq_rcpt_free(aq_rcpt_P _adb_rcpt);
sm_ret_T	 aq_rcpt_rm(aq_ctx_P _adb_ctx, aq_rcpt_P _adb_rcpt, uint _flags);
sm_ret_T	 aq_ta_new(aq_ta_P *_paq_ta);
sm_ret_T	 aq_ta_free(aq_ta_P _aq_ta);
sm_ret_T	 aq_ta_rm(aq_ctx_P _aq, aq_ta_P _aq_ta, bool _lockit);

sm_ret_T	 aq_rcptsent2da(void *_ctx);

sm_ret_T	 aq_raise_limit(aq_ctx_P _aq_ctx, uint _limit, thr_lock_T _locktype);
sm_ret_T	 aq_lower_limit(aq_ctx_P _aq_ctx, uint _limit, thr_lock_T _locktype);
sm_ret_T	 aq_get_limits(aq_ctx_P _aq_ctx, uint *_pentries, uint *_plimit, uint *_pmax_entries, thr_lock_T _locktype);

sm_ret_T	 aq_upd_ta_rcpt_cnts(aq_ta_P _aq_ta, smtp_status_T _oldstatus, smtp_status_T _newstatus, sm_log_ctx_P _lctx);

#define AQR_TXT_COMPLETE	1
sm_ret_T	 aq_rcpt_status2txt(aq_rcpt_P _aq_rcpt, sm_str_P _errmsg);

#endif /* SM_ACTDB_H */
