#!/bin/sh
# $Id: common.sh,v 1.27 2005/10/18 17:31:33 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# set common variables for test programs
# needs: SD
# ----------------------------------------

# paths etc for various (test) programs
DEFEDB=defedb
IBDBDIR='ibdb/ibdb'
IBDB='ibd00*'
SMTPCSOCK=qmsmtpc/qmsmtpc
SMARSOCK="qmsmar/qmsmar"

# path to CDB for lmtp sink (smtps3)
LMTPDIR="lmtpdir/"

# some filenames for the sinks
B1=lmtpdir/1/S000000000000000100
B2=lmtpdir/2/S000000000000000200
B3=lmtpdir/3/S000000000000000300
S1=smtpdir/1/S000000000000000100
S2=smtpdir/2/S000000000000000200
S3=smtpdir/3/S000000000000000300
S4=smtpdir/4/S000000000000000400

# port numbers to use
SNKPORT=${SM_SNKPORT:-8753}
SRVPORT=${SM_SRVPORT:-1579}

# some logfile names
SRVL="sink.log"
LMTPL="lmtp.log"
CLTL="source.log"
CLTL2="source2.log"
CLTL3="source3.log"
PML="m0.log"
SCL="c0.log"

# host on which to listen/to which to send
H=localhost
PIDS=pids
PMIDS=pmids
STE="../statethreads/examples"
EDBR=${EDBR:-../checks/t-edbr-0}
export STE CLTL EDBR H PIDS

#
SMXCNF=smx.conf
MCPCNF=${SMXCNF}
#MCPCNF=mcp.conf

# do not run as root
../libcheck/noroot || exit 1

# get USER
. ${SD}/../check2/user.sh

#
AWK=awk
CAT=cat
DIFF=diff
EGREP=egrep
GREP=grep
SED=sed

# get nameserver
if test X"${SM_NAMESERVER}" != "X"
then
  NS=${SM_NAMESERVER}
else
  NS=`${GREP} '^nameserver' /etc/resolv.conf | head -1 | sed -e 's/nameserver[	 ]*\([0-9][0-9\.]*\).*$/\1/'`
fi

# for debugging on some *BSD; how about others?
#export MALLOC_OPTIONS="J"

VERBOSE=${SM_VERBOSE:-false}
MM=../libsmmap/t-mm
IDBR0=../libibdb/t-idbr-0

ALI=aliases
ALIMAP=${ALI}.db
ACC=access
ACCMAP=${ACC}.db
QMGRCONF=qmgr_conf
QMGRCONFMAP=${QMGRCONF}.db
MT=mt
MTMAP=${MT}
#MTMAP=${MT}.db

#XREF
SMTP_R_QUICK=0x00010000

SHELL=/bin/sh
test -x /bin/ksh && SHELL=/bin/ksh

ERRS=0
ERR=false
ERRORPAT="'ERROR|FATAL|CRIT|ALERT'"
FATALPAT="'FATAL|CRIT|ALERT'"

SRC=${SD}/../smar/common.sh
if test -x ${SRC}
then
. ${SRC}
fi
