/*
 * Copyright (c) 2002-2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-str.c,v 1.15 2004/11/18 18:50:57 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/error.h"
#include "sm/rpool.h"
#include "sm/test.h"
#include "sm/str.h"

#include <stdio.h>

#define SMAXLEN	256

static void
test_harness(sm_rpool_P a)
{
	sm_str_P s;
	int i;
	size_t len;
	bool b;
	sm_ret_T ret;
	char buf[1024];
	uchar *data;

	/* XXX last character of the string is tested below! */
	char *magic = "magic buf";

	s = sm_str_scpy(a, magic, SMAXLEN);
	SM_TEST(s != NULL);
	SM_TEST(sm_str_getlen(s) == strlen(magic));
	SM_TEST(SM_STR_LAST(s) == magic[strlen(magic) - 1]);
	SM_TEST(SM_STR_LAST(s) == 'f');
	sm_str_free(s);

	s = sm_str_scpyn(a, magic, strlen(magic), SMAXLEN);
	SM_TEST(s != NULL);
	SM_TEST(sm_str_getlen(s) == strlen(magic));
	SM_TEST(strcmp((char *) sm_str_getdata(s), magic) == 0);
	SM_TEST(SM_STR_LAST(s) == magic[strlen(magic) - 1]);
	SM_TEST(SM_STR_LAST(s) == 'f');
	SM_TEST(sm_str_put(s, (uchar) ':') == SM_SUCCESS);
	SM_TEST(sm_str_getlen(s) == strlen(magic) + 1);
	SM_TEST(sm_str_scat(s, magic) == SM_SUCCESS);
	SM_TEST(sm_str_getlen(s) == 2 * strlen(magic) + 1);
	sm_str_clr(s);
	SM_TEST(sm_str_getlen(s) == 0);
	SM_TEST(strlen((char *) sm_str_getdata(s)) == 0);
	SM_TEST(sm_str_scatn(s, magic, strlen(magic)) == SM_SUCCESS);
	SM_TEST(sm_str_getlen(s) == strlen(magic));
	SM_TEST(strcmp(magic,(char *)  sm_str_getdata(s)) == 0);
	data =  sm_str_copydata(NULL, s);
	SM_TEST(data != NULL);
	SM_TEST(strcmp(magic,(char *) data) == 0);
	sm_free(data);
	sm_str_free(s);

	s = sm_str_new(NULL, 25, 255);
	SM_TEST(s != NULL);
	SM_TEST(sm_str_getlen(s) == 0);
#if HAVE_SNPRINTF
	len = snprintf(buf, sizeof(buf), "%s|%s", magic, magic);
	SM_TEST(sm_str_printf(s, "%s|%s", magic, magic) == len);
	SM_TEST(strcmp((char *) sm_str_getdata(s), buf) == 0);
	SM_TEST(sm_str_printf(s, magic) == strlen(magic));
	SM_TEST(sm_str_getlen(s) == len + strlen(magic));
#endif /* HAVE_SNPRINTF */
	sm_str_free(s);

	s = sm_str_new(NULL, 10, 100);
	SM_TEST(s != NULL);
	for (i = 0; i < 100; i++)
		SM_TEST(SM_STR_PUT(s, ':') == SM_SUCCESS);
	SM_TEST(sm_str_getlen(s) == 100);
	SM_TEST(SM_STR_PUT(s, ':') != SM_SUCCESS);
	SM_TEST(sm_str_getlen(s) == 100);
	sm_str_free(s);

	s = sm_str_new(NULL, 10, 100);
	SM_TEST(s != NULL);
	SM_TEST(sm_str_getlen(s) == 0);
	sm_str_free(s);

	s = sm_str_scpy(a, "MaGIc BuF", SMAXLEN);
	SM_TEST(s != NULL);
	b = sm_str2lower(s);
	SM_TEST(b);
	SM_TEST(strcmp((char *) sm_str_getdata(s), "magic buf") == 0);
	sm_str_free(s);

	s = sm_str_scpy(a, "mAgiC bUf", SMAXLEN);
	SM_TEST(s != NULL);
	b = sm_str2lower(s);
	SM_TEST(b);
	SM_TEST(strcmp((char *) sm_str_getdata(s), "magic buf") == 0);
	sm_str_free(s);

	s = sm_str_scpy(a, "MAGIC BUF 1234 fF", SMAXLEN);
	SM_TEST(s != NULL);
	b = sm_str2lower(s);
	SM_TEST(b);
	SM_TEST(strcmp((char *) sm_str_getdata(s), "magic buf 1234 ff") == 0);
	sm_str_free(s);

	s = sm_str_scpy(a, "magic buf", SMAXLEN);
	SM_TEST(s != NULL);
	b = sm_str2lower(s);
	SM_TEST(!b);
	SM_TEST(strcmp((char *) sm_str_getdata(s), "magic buf") == 0);
	sm_str_free(s);

	s = sm_str_scpy(a, "magic buf.", SMAXLEN);
	i = sm_str_getlen(s);
	SM_TEST(s != NULL);
	ret = sm_str_rm_trail(s, ".");
	SM_TEST(ret == 1);
	SM_TEST(i == sm_str_getlen(s) + 1);
	sm_str_free(s);

	s = sm_str_scpy(a, "magic buf", SMAXLEN);
	i = sm_str_getlen(s);
	SM_TEST(s != NULL);
	ret = sm_str_rm_trail(s, " ");
	SM_TEST(ret == 0);
	SM_TEST(i == sm_str_getlen(s));
	sm_str_free(s);

	s = sm_str_scpy(a, "magic buf", SMAXLEN);
	i = sm_str_getlen(s);
	SM_TEST(s != NULL);
	ret = sm_str_rm_trail_sp(s);
	SM_TEST(ret == 0);
	SM_TEST(i == sm_str_getlen(s));
	sm_str_free(s);

	s = sm_str_scpy(a, "magic buf ", SMAXLEN);
	i = sm_str_getlen(s);
	SM_TEST(s != NULL);
	ret = sm_str_rm_trail(s, " ");
	SM_TEST(ret == 1);
	SM_TEST(i == sm_str_getlen(s) + 1);
	sm_str_free(s);

	s = sm_str_scpy(a, "magic buf ", SMAXLEN);
	i = sm_str_getlen(s);
	SM_TEST(s != NULL);
	ret = sm_str_rm_trail_sp(s);
	SM_TEST(ret == 1);
	SM_TEST(i == sm_str_getlen(s) + 1);
	SM_TEST(s->sm_str_base[i - 1] == '\0');
	SM_TEST(s->sm_str_base[i - 2] == 'f');
	sm_str_free(s);

	s = sm_str_scpy(a, "magic buf \t ", SMAXLEN);
	i = sm_str_getlen(s);
	SM_TEST(s != NULL);
	ret = sm_str_rm_trail_sp(s);
	SM_TEST(ret == 3);
	SM_TEST(i == sm_str_getlen(s) + 3);
	SM_TEST(s->sm_str_base[i - 3] == '\0');
	SM_TEST(s->sm_str_base[i - 4] == 'f');
	sm_str_free(s);

	s = sm_str_new(NULL, 25, 0);
#if 0
// 	REQUIRE((f = fopen("../../libsmi/t/data-buf-test", "r")) != NULL);
// 	while (sm_str_readline_stream(s, f) != NULL)
// 	{
// 		i++;
// 		fprintf(stderr, "%s\n", sm_str_getdata(s));
// 	}
// 	SM_TEST(i == 2);
// 	fclose(f);
// 
// 	REQUIRE((f = fopen("../../libsmi/t/data-buf-test", "r")) != NULL);
// 	SM_TEST(sm_str_slurp_stream(s, f) == 62);
// 	fclose(f);
// 
// 	SM_TEST(sm_str_split_quoted(NULL, "'") == NULL);
// 
// 	SM_TEST((v = sm_str_split_quoted(NULL, "")) != NULL);
// 	SM_TEST(vector_length(v) == 0);
// 
// 	SM_TEST((v = sm_str_split_quoted(NULL, "one two three")) != NULL);
// 	SM_TEST(vector_length(v) == 3);
// 	SM_TEST(strcmp(vector_index(v, 0), "one") == 0);
// 	SM_TEST(strcmp(vector_index(v, 1), "two") == 0);
// 	SM_TEST(strcmp(vector_index(v, 2), "three") == 0);
// 
// #ifndef WIN32
// 	SM_TEST((v = sm_str_split_quoted(NULL, "one \"quoted\" with\\ space with\\ \\\"quotes\\\"")) != NULL);
// 	SM_TEST(vector_length(v) == 4);
// 	SM_TEST(strcmp(vector_index(v, 1), "quoted") == 0);
// 	SM_TEST(strcmp(vector_index(v, 2), "with space") == 0);
// 	SM_TEST(strcmp(vector_index(v, 3), "with \"quotes\"") == 0);
// #endif /* ! WIN32 */
#endif /* 0 */
	sm_str_free(s);
}

int
main(int argc, char *argv[])
{
	sm_rpool_P a;

	sm_test_begin(argc, argv, "test buf");

	/* create an rpool for entire test */
	a = sm_rpool_new(NULL);
	SM_TEST(a != NULL);
	test_harness(a);
	sm_rpool_delete(a);

	/* test without rpool */
	test_harness(NULL);
	return sm_test_end();
}
