/*
 * Copyright (c) 2003, 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_IDSTR(id, "@(#)$Id: t-fsfree-0.c,v 1.5 2004/12/29 23:47:29 ca Exp $")

#include "sm/fs.h"
#include "sm/statfs.h"
#include "sm/io.h"
#include "sm/test.h"

static int Verbose;

#define FS_ENTRIES	8
#define CHG1	100L

static sm_ret_T
test(const char *path)
{
	sm_ret_T ret;
	int i1, i2;
	ulong f1, f2;
	fs_ctx_P fs_ctx;

	ret = fs_ctx_open(FS_ENTRIES, &fs_ctx);
	SM_TEST(ret == SM_SUCCESS);
	SM_TEST(fs_ctx != NULL);
	if (fs_ctx == NULL)
		return ret;

	ret = fs_new(fs_ctx, path, &i1);
	SM_TEST(ret == SM_SUCCESS);

	ret = fs_new(fs_ctx, path, &i2);
	SM_TEST(ret == SM_SUCCESS);
	SM_TEST(i1 == i2);

	ret = fs_getfree(fs_ctx, i1, &f1);
	SM_TEST(ret == SM_SUCCESS);

	ret = fs_chgfree(fs_ctx, i1, CHG1, &f2);
	SM_TEST(ret == SM_SUCCESS);
	SM_TEST(f1 + CHG1 == f2);

	ret = fs_chgfree(fs_ctx, i1, 0 - CHG1, &f2);
	SM_TEST(ret == SM_SUCCESS);
	SM_TEST(f1 == f2);

	ret = fs_chgfree(fs_ctx, i1, 0 - CHG1, &f2);
	SM_TEST(ret == SM_SUCCESS);
	SM_TEST(f1 - CHG1 == f2);

	ret = fs_ctx_close(fs_ctx);
	SM_TEST(ret == SM_SUCCESS);

	return ret;
}


int
main(int argc, char *argv[])
{
	int c, r;
	char *dir, *prg;

	opterr = 0;
	Verbose = 0;
	dir = ".";
	prg = argv[0];
	while ((c = getopt(argc, argv, "V")) != -1)
	{
		switch (c)
		{
		  case 'V':
			++Verbose;
			break;
		  default:
			exit(1);
		}
	}
	argc -= optind;
	argv += optind;
	sm_test_begin(argc, argv, "test freediskspace");
	if (argc > 0)
	{
		for (r = 0; r < argc; r++)
		{
			test(argv[r]);
		}
	}
	else
	{
		test(dir);
	}
	return sm_test_end();
}
