#!/usr/bin/perl

package eBay::API::XML::DataType::SearchLocationType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SearchLocationType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::SearchLocationType

=head1 DESCRIPTION

One of the data filters used when searching for items using
GetSearchResults or GetCategoryListings. Allows filtering based on the 
location of the item or its availability relative to an eBay site. Or allows 
for filtering based on regional listing.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::SearchLocationType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::SiteLocationType;


my @gaProperties = ( [ 'RegionID', 'xs:string', '', '', '' ]
	, [ 'SiteLocation', 'ns:SiteLocationType', ''
	     ,'eBay::API::XML::DataType::SiteLocationType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setRegionID()

Specifies a region ID. The item must have been listed for the specified 
region to be returned in the search result set.

  Calls: GetSearchResults
         GetCategoryListings
  RequiredInput: No

#    Argument: 'xs:string'

=cut

sub setRegionID {
  my $self = shift;
  $self->{'RegionID'} = shift
}

=head2 getRegionID()

#    Returns: 'xs:string'

=cut

sub getRegionID {
  my $self = shift;
  return $self->{'RegionID'};
}


=head2 setSiteLocation()

Specifies a filter based on a particular eBay site and the item's relation 
to that site (items listed with a site's currency, items located in the 
country for the site, items available to the country for the site, and 
items listed on the specified site).

  Calls: GetSearchResults
         GetCategoryListings
  RequiredInput: No

#    Argument: 'ns:SiteLocationType'

=cut

sub setSiteLocation {
  my $self = shift;
  $self->{'SiteLocation'} = shift
}

=head2 getSiteLocation()

#    Returns: 'ns:SiteLocationType'

=cut

sub getSiteLocation {
  my $self = shift;
  return $self->_getDataTypeInstance( 'SiteLocation'
		,'eBay::API::XML::DataType::SiteLocationType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
