
BEGIN {
  unless ($ENV{AUTHOR_TESTING}) {
    print qq{1..0 # SKIP these tests are for testing by the author\n};
    exit
  }
}

use strict;
use warnings;

# this test was generated with Dist::Zilla::Plugin::Test::EOL 0.19

use Test::More 0.88;
use Test::EOL;

my @files = (
    'lib/WWW/LogicBoxes.pm',
    'lib/WWW/LogicBoxes/Contact.pm',
    'lib/WWW/LogicBoxes/Contact/CA.pm',
    'lib/WWW/LogicBoxes/Contact/CA/Agreement.pm',
    'lib/WWW/LogicBoxes/Contact/Factory.pm',
    'lib/WWW/LogicBoxes/Contact/US.pm',
    'lib/WWW/LogicBoxes/Customer.pm',
    'lib/WWW/LogicBoxes/Domain.pm',
    'lib/WWW/LogicBoxes/Domain/Factory.pm',
    'lib/WWW/LogicBoxes/DomainAvailability.pm',
    'lib/WWW/LogicBoxes/DomainRequest.pm',
    'lib/WWW/LogicBoxes/DomainRequest/Registration.pm',
    'lib/WWW/LogicBoxes/DomainRequest/Transfer.pm',
    'lib/WWW/LogicBoxes/DomainTransfer.pm',
    'lib/WWW/LogicBoxes/IRTPDetail.pm',
    'lib/WWW/LogicBoxes/PhoneNumber.pm',
    'lib/WWW/LogicBoxes/PrivateNameServer.pm',
    'lib/WWW/LogicBoxes/Role/Command.pm',
    'lib/WWW/LogicBoxes/Role/Command/Contact.pm',
    'lib/WWW/LogicBoxes/Role/Command/Customer.pm',
    'lib/WWW/LogicBoxes/Role/Command/Domain.pm',
    'lib/WWW/LogicBoxes/Role/Command/Domain/Availability.pm',
    'lib/WWW/LogicBoxes/Role/Command/Domain/PrivateNameServer.pm',
    'lib/WWW/LogicBoxes/Role/Command/Domain/Registration.pm',
    'lib/WWW/LogicBoxes/Role/Command/Domain/Transfer.pm',
    'lib/WWW/LogicBoxes/Role/Command/Raw.pm',
    'lib/WWW/LogicBoxes/Types.pm',
    't/00-compile.t',
    't/author-critic.t',
    't/author-eol.t',
    't/author-mojibake.t',
    't/author-no-tabs.t',
    't/author-pod-coverage.t',
    't/author-pod-linkcheck.t',
    't/author-pod-syntax.t',
    't/author-portability.t',
    't/author-test-version.t',
    't/contact/00-object.t',
    't/contact/ca/00-object.t',
    't/contact/ca/agreement/00-object.t',
    't/contact/factory/construct_from_response/01-com.t',
    't/contact/factory/construct_from_response/02-us.t',
    't/contact/factory/construct_from_response/03-biz.t',
    't/contact/factory/construct_from_response/04-club.t',
    't/contact/factory/construct_from_response/05-co.t',
    't/contact/factory/construct_from_response/06-info.t',
    't/contact/us/00-object.t',
    't/customer/00-object.t',
    't/domain/00-object.t',
    't/domainavailability/00-object.t',
    't/domainavailability/01-domain_parts.t',
    't/domainrequest/00-object.t',
    't/domainrequest/registration/00-object.t',
    't/domainrequest/transfer/00-object.t',
    't/domaintransfer/00-object.t',
    't/irtpdetail/00-object.t',
    't/legacy/01-domains.t',
    't/lib/Test/WWW/LogicBoxes.pm',
    't/lib/Test/WWW/LogicBoxes/Contact.pm',
    't/lib/Test/WWW/LogicBoxes/Customer.pm',
    't/lib/Test/WWW/LogicBoxes/Domain.pm',
    't/lib/Test/WWW/LogicBoxes/DomainRegistration.pm',
    't/logicboxes/00-object.t',
    't/phonenumber/00-object.t',
    't/phonenumber/01-new.t',
    't/privatenameserver/00-object.t',
    't/release-cpan-changes.t',
    't/release-dist-manifest.t',
    't/release-distmeta.t',
    't/release-kwalitee.t',
    't/release-meta-json.t',
    't/release-minimum-version.t',
    't/release-unused-vars.t',
    't/role/command/00-object.t',
    't/role/command/contact/00-object.t',
    't/role/command/contact/01-get_contact_by_id.t',
    't/role/command/contact/02-delete_contact_by_id.t',
    't/role/command/contact/03-update.t',
    't/role/command/contact/04-get_ca_registrant_agreement.t',
    't/role/command/contact/create/01-contact.t',
    't/role/command/contact/create/02-contact-us.t',
    't/role/command/contact/create/03-contact-ca.t',
    't/role/command/customer/00-object.t',
    't/role/command/customer/01-create_customer.t',
    't/role/command/customer/02-get_customer_by_id.t',
    't/role/command/customer/03-get_customer_by_username.t',
    't/role/command/domain/00-object.t',
    't/role/command/domain/01-get_domain_by_id.t',
    't/role/command/domain/02-get_domain_by_name.t',
    't/role/command/domain/03-update_domain_contacts.t',
    't/role/command/domain/04-enable_domain_lock_by_id.t',
    't/role/command/domain/05-disable_domain_lock_by_id.t',
    't/role/command/domain/06-enable_domain_privacy.t',
    't/role/command/domain/07-disable_domain_privacy.t',
    't/role/command/domain/08-update_domain_nameservers.t',
    't/role/command/domain/09-renew.t',
    't/role/command/domain/10-resend_verification_email.t',
    't/role/command/domain/availability/00-object.t',
    't/role/command/domain/availability/01-check_availability.t',
    't/role/command/domain/availability/02-suggest_domain_names.t',
    't/role/command/domain/privatenameserver/00-object.t',
    't/role/command/domain/privatenameserver/01-create_private_nameserver.t',
    't/role/command/domain/privatenameserver/02-rename_private_nameserver.t',
    't/role/command/domain/privatenameserver/03-modify_private_nameserver_ip.t',
    't/role/command/domain/privatenameserver/04-delete_private_nameserver_ip.t',
    't/role/command/domain/privatenameserver/05-delete_private_nameserver.t',
    't/role/command/domain/registration/00-object.t',
    't/role/command/domain/registration/01-delete_domain_registration_by_id.t',
    't/role/command/domain/registration/register_domain/01-com.t',
    't/role/command/domain/registration/register_domain/02-ca.t',
    't/role/command/domain/transfer/00-object.t',
    't/role/command/domain/transfer/01-is_domain_transferable.t',
    't/role/command/domain/transfer/02-transfer_domain.t',
    't/role/command/domain/transfer/03-cancel_transfer.t',
    't/role/command/domain/transfer/04-resend_transfer_approval_mail.t',
    't/role/command/raw/00-object.t'
);

eol_unix_ok($_, { trailing_whitespace => 1 }) foreach @files;
done_testing;
