/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import javax.measure.Dimension;
import javax.measure.IncommensurableException;
import javax.measure.Quantity;
import javax.measure.UnconvertibleException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.spi.QuantityFactory;
import org.apache.sis.internal.converter.SurjectiveConverter;
import org.apache.sis.math.Fraction;
import org.apache.sis.measure.AbstractConverter;
import org.apache.sis.measure.AbstractUnit;
import org.apache.sis.measure.ConventionalUnit;
import org.apache.sis.measure.LinearConverter;
import org.apache.sis.measure.ScalarFactory;
import org.apache.sis.measure.ScalarFallback;
import org.apache.sis.measure.UnitDimension;
import org.apache.sis.measure.UnitRegistry;
import org.apache.sis.measure.Units;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.resources.Errors;

final class SystemUnit<Q extends Quantity<Q>>
extends AbstractUnit<Q>
implements QuantityFactory<Q> {
    private static final long serialVersionUID = 4097466138698631914L;
    final Class<Q> quantity;
    final UnitDimension dimension;
    final transient ScalarFactory<Q> factory;
    private transient ConventionalUnit<Q>[] related;

    SystemUnit(Class<Q> clazz, UnitDimension unitDimension, String string, byte by, short s, ScalarFactory<Q> scalarFactory) {
        super(string, by, s);
        this.quantity = clazz;
        this.dimension = unitDimension;
        this.factory = scalarFactory;
    }

    private SystemUnit<?> create(UnitDimension unitDimension) {
        if (unitDimension == this.dimension) {
            return this;
        }
        SystemUnit<Object> systemUnit = Units.get(unitDimension);
        if (systemUnit == null) {
            systemUnit = new SystemUnit<Q>(null, unitDimension, null, 0, 0, null);
        }
        return systemUnit;
    }

    @Override
    public Dimension getDimension() {
        return this.dimension;
    }

    @Override
    public SystemUnit<Q> getSystemUnit() {
        return this;
    }

    @Override
    public Map<SystemUnit<?>, Integer> getBaseUnits() {
        Map<UnitDimension, Integer> map = this.dimension.getBaseDimensions();
        if (map == null) {
            return null;
        }
        return ObjectConverters.derivedKeys(map, DimToUnit.INSTANCE, Integer.class);
    }

    @Override
    final Map<SystemUnit<?>, Fraction> getBaseSystemUnits() {
        return ObjectConverters.derivedKeys(this.dimension.components, DimToUnit.INSTANCE, Fraction.class);
    }

    @Override
    public <T extends Quantity<T>> Unit<T> asType(Class<T> clazz) throws ClassCastException {
        ArgumentChecks.ensureNonNull("type", clazz);
        if (clazz == this.quantity) {
            SystemUnit<T> systemUnit;
            if (this.getSymbol() == null && (systemUnit = Units.get(clazz)) != null) {
                return systemUnit;
            }
            return this;
        }
        SystemUnit<T> systemUnit = Units.get(clazz);
        if (systemUnit == null) {
            systemUnit = new SystemUnit<T>(clazz, this.dimension, null, 0, 0, null);
        }
        if (!this.dimension.equals(systemUnit.dimension)) {
            throw new ClassCastException(Errors.format((short)64, new Object[]{this, this.quantity != null ? this.quantity.getSimpleName() : "?", this.dimension, clazz.getSimpleName(), systemUnit.dimension}));
        }
        return systemUnit;
    }

    final boolean equalsIgnoreMetadata(Unit<Q> unit) {
        Class<Q> clazz;
        if (this.quantity != null && unit instanceof SystemUnit && (clazz = ((SystemUnit)unit).quantity) != null) {
            return this.quantity == clazz;
        }
        assert (unit == unit.getSystemUnit()) : unit;
        return this.dimension.equals(unit.getDimension());
    }

    @Override
    public UnitConverter getConverterTo(Unit<Q> unit) throws UnconvertibleException {
        ArgumentChecks.ensureNonNull("that", unit);
        Unit<Q> unit2 = unit.getSystemUnit();
        if (unit2 != this && !this.equalsIgnoreMetadata(unit2)) {
            throw new UnconvertibleException(this.incompatible(unit));
        }
        if (unit2 == unit) {
            return LinearConverter.IDENTITY;
        }
        return unit.getConverterTo(unit2).inverse();
    }

    @Override
    public UnitConverter getConverterToAny(Unit<?> unit) throws IncommensurableException {
        ArgumentChecks.ensureNonNull("that", unit);
        Unit<?> unit2 = unit.getSystemUnit();
        if (unit2 != this && !this.isCompatible(unit2)) {
            throw new IncommensurableException(this.incompatible(unit));
        }
        if (unit2 == unit) {
            return LinearConverter.IDENTITY;
        }
        return unit.getConverterToAny(unit2).inverse();
    }

    @Override
    public Unit<Q> alternate(String string) {
        int n;
        ArgumentChecks.ensureNonEmpty("symbol", string);
        for (int i = 0; i < string.length(); i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (SystemUnit.isSymbolChar(n)) continue;
            throw new IllegalArgumentException(Errors.format((short)49, "symbol", String.valueOf(Character.toChars(n))));
        }
        if (string.equals(this.getSymbol())) {
            return this;
        }
        SystemUnit<Q> systemUnit = new SystemUnit<Q>(this.quantity, this.dimension, string, 0, 0, this.factory);
        if (this.quantity != null) {
            Object object = UnitRegistry.putIfAbsent(string, systemUnit);
            if (object != null) {
                if (object instanceof SystemUnit) {
                    SystemUnit systemUnit2 = (SystemUnit)object;
                    if (this.quantity.equals(systemUnit2.quantity) && this.dimension.equals(systemUnit2.dimension)) {
                        return systemUnit2;
                    }
                }
                throw new IllegalArgumentException(Errors.format((short)27, string));
            }
            UnitRegistry.putIfAbsent(this.quantity, systemUnit);
        }
        return systemUnit;
    }

    @Override
    public Unit<?> multiply(Unit<?> unit) {
        ArgumentChecks.ensureNonNull("multiplier", unit);
        return this.combine(unit, false);
    }

    @Override
    public Unit<?> divide(Unit<?> unit) {
        ArgumentChecks.ensureNonNull("divisor", unit);
        return this.combine(unit, true);
    }

    private <T extends Quantity<T>> Unit<?> combine(Unit<T> unit, boolean bl) {
        Unit<T> unit2 = unit.getSystemUnit();
        Dimension dimension = unit2.getDimension();
        Unit<Object> unit3 = this.create(bl ? this.dimension.divide(dimension) : this.dimension.multiply(dimension));
        if (unit2 != unit) {
            UnitConverter unitConverter = unit.getConverterTo(unit2);
            if (!unitConverter.isLinear()) {
                throw new IllegalArgumentException(Errors.format((short)104, unit));
            }
            if (bl) {
                unitConverter = unitConverter.inverse();
            }
            unit3 = unit3.transform(unitConverter);
        }
        return unit3;
    }

    @Override
    public Unit<?> pow(int n) {
        return this.create(this.dimension.pow(n));
    }

    @Override
    public Unit<?> root(int n) {
        return this.create(this.dimension.root(n));
    }

    @Override
    public Unit<Q> transform(UnitConverter unitConverter) {
        ArgumentChecks.ensureNonNull("operation", unitConverter);
        AbstractUnit abstractUnit = this;
        if (this == Units.KILOGRAM) {
            abstractUnit = (AbstractUnit)Units.GRAM;
            unitConverter = unitConverter.concatenate(LinearConverter.forPrefix('k'));
        }
        return ConventionalUnit.create(abstractUnit, unitConverter);
    }

    final void related(int n) {
        if (this.related != null) {
            throw new IllegalStateException();
        }
        this.related = new ConventionalUnit[n];
    }

    @Override
    final ConventionalUnit<Q>[] related() {
        return this.related;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            SystemUnit systemUnit = (SystemUnit)object;
            return Objects.equals(this.quantity, systemUnit.quantity) && this.dimension.equals(systemUnit.dimension);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 37 * this.dimension.hashCode();
    }

    @Override
    public Quantity<Q> create(Number number, Unit<Q> unit) {
        double d = AbstractConverter.doubleValue(number);
        if (this.factory != null) {
            return this.factory.create(d, unit);
        }
        return ScalarFallback.factory(d, unit, this.quantity);
    }

    private static final class DimToUnit
    extends SurjectiveConverter<UnitDimension, SystemUnit<?>>
    implements Serializable {
        private static final long serialVersionUID = 7545067577687885675L;
        static final DimToUnit INSTANCE = new DimToUnit();

        private DimToUnit() {
        }

        @Override
        public Class<UnitDimension> getSourceClass() {
            return UnitDimension.class;
        }

        @Override
        public Class<SystemUnit<?>> getTargetClass() {
            return SystemUnit.class;
        }

        @Override
        public SystemUnit<?> apply(UnitDimension unitDimension) {
            return Units.get(unitDimension);
        }

        Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }
}

