/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.james.mime4j.dom.Entity;
import org.apache.james.mime4j.dom.Multipart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMultipart
implements Multipart {
    protected List<Entity> bodyParts = new LinkedList<Entity>();
    private Entity parent = null;
    private String subType;

    public AbstractMultipart(String subType) {
        this.subType = subType;
    }

    @Override
    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    @Override
    public Entity getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Entity parent) {
        this.parent = parent;
        for (Entity bodyPart : this.bodyParts) {
            bodyPart.setParent(parent);
        }
    }

    @Override
    public int getCount() {
        return this.bodyParts.size();
    }

    @Override
    public List<Entity> getBodyParts() {
        return Collections.unmodifiableList(this.bodyParts);
    }

    @Override
    public void setBodyParts(List<Entity> bodyParts) {
        this.bodyParts = bodyParts;
        for (Entity bodyPart : bodyParts) {
            bodyPart.setParent(this.parent);
        }
    }

    @Override
    public void addBodyPart(Entity bodyPart) {
        if (bodyPart == null) {
            throw new IllegalArgumentException();
        }
        this.bodyParts.add(bodyPart);
        bodyPart.setParent(this.parent);
    }

    @Override
    public void addBodyPart(Entity bodyPart, int index) {
        if (bodyPart == null) {
            throw new IllegalArgumentException();
        }
        this.bodyParts.add(index, bodyPart);
        bodyPart.setParent(this.parent);
    }

    @Override
    public Entity removeBodyPart(int index) {
        Entity bodyPart = this.bodyParts.remove(index);
        bodyPart.setParent(null);
        return bodyPart;
    }

    @Override
    public Entity replaceBodyPart(Entity bodyPart, int index) {
        if (bodyPart == null) {
            throw new IllegalArgumentException();
        }
        Entity replacedEntity = this.bodyParts.set(index, bodyPart);
        if (bodyPart == replacedEntity) {
            throw new IllegalArgumentException("Cannot replace body part with itself");
        }
        bodyPart.setParent(this.parent);
        replacedEntity.setParent(null);
        return replacedEntity;
    }

    @Override
    public abstract String getPreamble();

    @Override
    public abstract void setPreamble(String var1);

    @Override
    public abstract String getEpilogue();

    @Override
    public abstract void setEpilogue(String var1);

    @Override
    public void dispose() {
        for (Entity bodyPart : this.bodyParts) {
            bodyPart.dispose();
        }
    }
}

