/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel;

import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;

public class PDPageNode
implements COSObjectable {
    private COSDictionary page;

    public PDPageNode() {
        this.page = new COSDictionary();
        this.page.setItem(COSName.TYPE, (COSBase)COSName.PAGES);
        this.page.setItem(COSName.KIDS, (COSBase)new COSArray());
        this.page.setItem(COSName.COUNT, (COSBase)COSInteger.ZERO);
    }

    public PDPageNode(COSDictionary pages) {
        this.page = pages;
    }

    public long updateCount() {
        long totalCount = 0L;
        List kids = this.getKids();
        for (Object next : kids) {
            if (next instanceof PDPage) {
                ++totalCount;
                continue;
            }
            PDPageNode node = (PDPageNode)next;
            totalCount += node.updateCount();
        }
        this.page.setLong(COSName.COUNT, totalCount);
        return totalCount;
    }

    public long getCount() {
        return ((COSNumber)this.page.getDictionaryObject(COSName.COUNT)).intValue();
    }

    public COSDictionary getDictionary() {
        return this.page;
    }

    public PDPageNode getParent() {
        PDPageNode parent = null;
        COSDictionary parentDic = (COSDictionary)this.page.getDictionaryObject("Parent", "P");
        if (parentDic != null) {
            parent = new PDPageNode(parentDic);
        }
        return parent;
    }

    public void setParent(PDPageNode parent) {
        this.page.setItem(COSName.PARENT, (COSBase)parent.getDictionary());
    }

    public COSBase getCOSObject() {
        return this.page;
    }

    public List getKids() {
        ArrayList actuals = new ArrayList();
        COSArray kids = PDPageNode.getAllKids(actuals, this.page, false);
        return new COSArrayList(actuals, kids);
    }

    public void getAllKids(List result) {
        PDPageNode.getAllKids(result, this.page, true);
    }

    private static COSArray getAllKids(List result, COSDictionary page, boolean recurse) {
        COSArray kids = (COSArray)page.getDictionaryObject(COSName.KIDS);
        for (int i = 0; i < kids.size(); ++i) {
            COSBase obj = kids.getObject(i);
            if (!(obj instanceof COSDictionary)) continue;
            COSDictionary kid = (COSDictionary)obj;
            if (COSName.PAGE.equals(kid.getDictionaryObject(COSName.TYPE))) {
                result.add(new PDPage(kid));
                continue;
            }
            if (recurse) {
                PDPageNode.getAllKids(result, kid, recurse);
                continue;
            }
            result.add(new PDPageNode(kid));
        }
        return kids;
    }

    public PDResources getResources() {
        PDResources retval = null;
        COSDictionary resources = (COSDictionary)this.page.getDictionaryObject(COSName.RESOURCES);
        if (resources != null) {
            retval = new PDResources(resources);
        }
        return retval;
    }

    public PDResources findResources() {
        PDResources retval = this.getResources();
        PDPageNode parent = this.getParent();
        if (retval == null && parent != null) {
            retval = parent.findResources();
        }
        return retval;
    }

    public void setResources(PDResources resources) {
        if (resources == null) {
            this.page.removeItem(COSName.RESOURCES);
        } else {
            this.page.setItem(COSName.RESOURCES, (COSBase)resources.getCOSDictionary());
        }
    }

    public PDRectangle getMediaBox() {
        PDRectangle retval = null;
        COSArray array = (COSArray)this.page.getDictionaryObject(COSName.MEDIA_BOX);
        if (array != null) {
            retval = new PDRectangle(array);
        }
        return retval;
    }

    public PDRectangle findMediaBox() {
        PDRectangle retval = this.getMediaBox();
        PDPageNode parent = this.getParent();
        if (retval == null && parent != null) {
            retval = parent.findMediaBox();
        }
        return retval;
    }

    public void setMediaBox(PDRectangle mediaBox) {
        if (mediaBox == null) {
            this.page.removeItem(COSName.MEDIA_BOX);
        } else {
            this.page.setItem(COSName.MEDIA_BOX, (COSBase)mediaBox.getCOSArray());
        }
    }

    public PDRectangle getCropBox() {
        PDRectangle retval = null;
        COSArray array = (COSArray)this.page.getDictionaryObject(COSName.CROP_BOX);
        if (array != null) {
            retval = new PDRectangle(array);
        }
        return retval;
    }

    public PDRectangle findCropBox() {
        PDRectangle retval = this.getCropBox();
        PDPageNode parent = this.getParent();
        if (retval == null && parent != null) {
            retval = this.findParentCropBox(parent);
        }
        if (retval == null) {
            retval = this.findMediaBox();
        }
        return retval;
    }

    private PDRectangle findParentCropBox(PDPageNode node) {
        PDRectangle rect = node.getCropBox();
        PDPageNode parent = node.getParent();
        if (rect == null && parent != null) {
            rect = this.findParentCropBox(node);
        }
        return rect;
    }

    public void setCropBox(PDRectangle cropBox) {
        if (cropBox == null) {
            this.page.removeItem(COSName.CROP_BOX);
        } else {
            this.page.setItem(COSName.CROP_BOX, (COSBase)cropBox.getCOSArray());
        }
    }

    public Integer getRotation() {
        Integer retval = null;
        COSNumber value = (COSNumber)this.page.getDictionaryObject(COSName.ROTATE);
        if (value != null) {
            retval = new Integer(value.intValue());
        }
        return retval;
    }

    public int findRotation() {
        int retval = 0;
        Integer rotation = this.getRotation();
        if (rotation != null) {
            retval = rotation;
        } else {
            PDPageNode parent = this.getParent();
            if (parent != null) {
                retval = parent.findRotation();
            }
        }
        return retval;
    }

    public void setRotation(int rotation) {
        this.page.setInt(COSName.ROTATE, rotation);
    }
}

