/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.dom.address;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.james.mime4j.dom.address.Address;
import org.apache.james.mime4j.dom.address.Mailbox;
import org.apache.james.mime4j.dom.address.MailboxList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group
extends Address {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final MailboxList mailboxList;

    public Group(String name, MailboxList mailboxes) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (mailboxes == null) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.mailboxList = mailboxes;
    }

    public Group(String name, Mailbox ... mailboxes) {
        this(name, new MailboxList(Arrays.asList(mailboxes), true));
    }

    public Group(String name, Collection<Mailbox> mailboxes) {
        this(name, new MailboxList(new ArrayList<Mailbox>(mailboxes), true));
    }

    public String getName() {
        return this.name;
    }

    public MailboxList getMailboxes() {
        return this.mailboxList;
    }

    @Override
    protected void doAddMailboxesTo(List<Mailbox> results) {
        for (Mailbox mailbox : this.mailboxList) {
            results.add(mailbox);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append(':');
        boolean first = true;
        for (Mailbox mailbox : this.mailboxList) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(' ');
            sb.append(mailbox);
        }
        sb.append(";");
        return sb.toString();
    }
}

