package Task::Map::Tube;

use strict;
use warnings;

our $VERSION = 0.47;

1;

__END__

=pod

=encoding utf8

=head1 NAME

Task::Map::Tube - Install the Map::Tube modules.

=head1 SYNOPSIS

 cpanm Task::Map::Tube

=head1 SEE ALSO

=over

=item L<Task::MapMetro::Maps>

Map::Metro maps in a bundle.

=item L<Task::Map::Tube::Metro>

Install the Map::Tube concrete metro modules.

=item L<Map::Tube>

Core library as Role (Moo) to process map data.

=item L<Map::Tube::CLI>

Command Line Interface for Map::Tube::* map.

=item L<Map::Tube::Cookbook>

Cookbook for Map::Tube library.

=item L<Map::Tube::Graph>

Graph output for Map::Tube.

=item L<Map::Tube::GraphViz>

GraphViz output for Map::Tube.

=item L<Map::Tube::Plugin::Formatter>

Formatter plugin for Map::Tube.

=item L<Map::Tube::Plugin::FuzzyFind>

Map::Tube add-on for finding stations and lines by inexact name.

=item L<Map::Tube::Plugin::Graph>

Graph plugin for Map::Tube.

=item L<Map::Tube::Text::Shortest>

Shortest route information via Map::Tube object.

=item L<Map::Tube::Text::Table>

Table output for Map::Tube.

=item L<Test::Map::Tube>

Interface to test Map::Tube (map data).

=back

=head1 REPOSITORY

L<https://github.com/michal-josef-spacek/Task-Map-Tube>

=head1 AUTHOR

Michal Josef Špaček L<mailto:skim@cpan.org>

L<http://skim.cz>

=head1 LICENSE AND COPYRIGHT

© 2014-2023 Michal Josef Špaček

Artistic License

BSD 2-Clause License

=head1 VERSION

0.47

=cut
