/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownNotifier;
import com.rabbitmq.client.ShutdownSignalException;
import java.util.ArrayList;
import java.util.List;

public class ShutdownNotifierComponent
implements ShutdownNotifier {
    private final Object monitor = new Object();
    private final List<ShutdownListener> shutdownListeners = new ArrayList<ShutdownListener>();
    private volatile ShutdownSignalException shutdownCause = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShutdownListener(ShutdownListener listener) {
        ShutdownSignalException sse = null;
        Object object = this.monitor;
        synchronized (object) {
            sse = this.shutdownCause;
            this.shutdownListeners.add(listener);
        }
        if (sse != null) {
            listener.shutdownCompleted(sse);
        }
    }

    public ShutdownSignalException getCloseReason() {
        return this.shutdownCause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners() {
        ShutdownSignalException sse = null;
        ShutdownListener[] sdls = null;
        Object object = this.monitor;
        synchronized (object) {
            sdls = this.shutdownListeners.toArray(new ShutdownListener[this.shutdownListeners.size()]);
            sse = this.shutdownCause;
        }
        for (ShutdownListener l : sdls) {
            try {
                l.shutdownCompleted(sse);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeShutdownListener(ShutdownListener listener) {
        Object object = this.monitor;
        synchronized (object) {
            this.shutdownListeners.remove(listener);
        }
    }

    public boolean isOpen() {
        return this.shutdownCause == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setShutdownCauseIfOpen(ShutdownSignalException sse) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.isOpen()) {
                this.shutdownCause = sse;
                return true;
            }
            return false;
        }
    }
}

