#!perl

use strict;
use warnings;

# This test was generated by inc::CheckJiraInChanges

use Test::More tests => 1;

my @commits = split /\n/, <<'EOC';
4a06a3b5 (sandbox/maint-v1.6, origin/maint-v1.6, dagolden/maint-v1.6) PERL-711 Support authSource URI option
7ff3f31e PERL-712 Fix undefined reference to strerror_r on Windows

EOC

my %ticket_map;
for my $commit ( @commits ) {
    for my $ticket ( $commit =~ /PERL-(\d+)/g ) {
        next if $ENV{CHECK_JIRA_SKIP}
            && grep { $ticket eq $_ } split " ", $ENV{CHECK_JIRA_SKIP};
        $ticket_map{$ticket} ||= [];
        push @{$ticket_map{$ticket}}, $commit;
    }
}

# grab Changes lines from new version to next un-indented line
open my $fh, "<:encoding(UTF-8)", "Changes";
my $changelog = do { local $/; <$fh> };

my @bad;
for my $ticket ( keys %ticket_map ) {
    if ( index( $changelog, "PERL-$ticket" ) < 0 ) {
       push @bad, $ticket;
    }
}

if ( !@commits ) {
    pass("No commits with Jira tickets");
}
else {
    ok( ! scalar @bad, "Jira tickets in Changes")
        or diag "Jira tickets missing:\n"
        . join("\n", map { "  * $_" } map { @{$ticket_map{$_}} } sort { $a <=> $b } @bad );
}
