/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.io.FileSequentialCollection;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.trees.LabeledScoredTreeReaderFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreeVisitor;
import edu.stanford.nlp.trees.Treebank;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DiskTreebank
extends Treebank {
    private static final boolean PRINT_FILENAMES = false;
    private final ArrayList<File> filePaths = new ArrayList();
    private final ArrayList<FileFilter> fileFilters = new ArrayList();
    private File currentFile;

    public DiskTreebank() {
        this(new LabeledScoredTreeReaderFactory());
    }

    public DiskTreebank(String encoding) {
        this(new LabeledScoredTreeReaderFactory(), encoding);
    }

    public DiskTreebank(TreeReaderFactory trf) {
        super(trf);
    }

    public DiskTreebank(TreeReaderFactory trf, String encoding) {
        super(trf, encoding);
    }

    public DiskTreebank(int initialCapacity) {
        this(initialCapacity, new LabeledScoredTreeReaderFactory());
    }

    public DiskTreebank(int initialCapacity, TreeReaderFactory trf) {
        this(trf);
    }

    @Override
    public void clear() {
        this.filePaths.clear();
        this.fileFilters.clear();
    }

    @Override
    public void loadPath(File path, FileFilter filt) {
        this.filePaths.add(path);
        this.fileFilters.add(filt);
    }

    @Override
    public void apply(TreeVisitor tp) {
        for (Tree t : this) {
            tp.visitTree(t);
        }
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    @Override
    public Iterator<Tree> iterator() {
        return new DiskTreebankIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DiskTreebankIterator
    implements Iterator<Tree> {
        private int fileUpto;
        Iterator<File> fileIterator;
        private TreeReader tr;
        private Tree storedTree = this.primeNextTree();

        private DiskTreebankIterator() {
        }

        private Tree primeNextTree() {
            Tree nextTree = null;
            int fpsize = DiskTreebank.this.filePaths.size();
            while (nextTree == null && this.fileUpto <= fpsize) {
                if (!(this.tr != null || this.fileIterator != null && this.fileIterator.hasNext())) {
                    if (this.fileUpto < fpsize) {
                        FileSequentialCollection fsc = new FileSequentialCollection(Collections.singletonList(DiskTreebank.this.filePaths.get(this.fileUpto)), (FileFilter)DiskTreebank.this.fileFilters.get(this.fileUpto));
                        this.fileIterator = fsc.iterator();
                    }
                    ++this.fileUpto;
                }
                while (nextTree == null && (this.tr != null || this.fileIterator != null && this.fileIterator.hasNext())) {
                    try {
                        while (nextTree == null && (this.tr != null || this.fileIterator != null && this.fileIterator.hasNext())) {
                            if (this.tr != null && (nextTree = this.tr.readTree()) == null) {
                                this.tr.close();
                                this.tr = null;
                            }
                            if (nextTree != null || this.fileIterator == null || !this.fileIterator.hasNext()) continue;
                            DiskTreebank.this.currentFile = this.fileIterator.next();
                            this.tr = DiskTreebank.this.treeReaderFactory().newTreeReader(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(DiskTreebank.this.currentFile), DiskTreebank.this.encoding())));
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeIOException("primeNextTree IO Exception in file " + DiskTreebank.this.currentFile, e);
                    }
                }
            }
            if (nextTree == null) {
                DiskTreebank.this.currentFile = null;
            }
            return nextTree;
        }

        @Override
        public boolean hasNext() {
            return this.storedTree != null;
        }

        @Override
        public Tree next() {
            if (this.storedTree == null) {
                throw new NoSuchElementException();
            }
            Tree ret = this.storedTree;
            this.storedTree = this.primeNextTree();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

