#!/usr/bin/env perl
use 5.020;
use warnings;
use UniEvent::HTTP;
use XLog;

XLog::set_logger(sub { say $_[0] });
XLog::set_level(XLog::VERBOSE_DEBUG());

my $pool = UniEvent::HTTP::Pool->new;
my $retr = 0;

my $req = UniEvent::HTTP::Request->new({
    uri => 'http://ya.ru/',
    timeout => 1,
    proxy => 'http://169.254.0.1:8888/',
    redirection_limit => 1,
    response_callback => sub {
        my ($request, $response, $error) = @_;
        if ($error) {
            warn $error;
            return;
        }
        say $response->body;
    },
});

$pool->request($req);

UE::Loop->default_loop->run;
