/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;

public class IndexLister {
    private TableDescriptor tableDescriptor;
    private IndexRowGenerator[] indexRowGenerators;
    private long[] indexConglomerateNumbers;
    private String[] indexNames;
    private IndexRowGenerator[] distinctIndexRowGenerators;
    private long[] distinctIndexConglomerateNumbers;
    private String[] distinctIndexNames;

    public IndexLister(TableDescriptor tableDescriptor) {
        this.tableDescriptor = tableDescriptor;
    }

    public IndexRowGenerator[] getIndexRowGenerators() throws StandardException {
        if (this.indexRowGenerators == null) {
            this.getAllIndexes();
        }
        return this.indexRowGenerators;
    }

    public long[] getIndexConglomerateNumbers() throws StandardException {
        if (this.indexConglomerateNumbers == null) {
            this.getAllIndexes();
        }
        return this.indexConglomerateNumbers;
    }

    public String[] getIndexNames() throws StandardException {
        if (this.indexNames == null) {
            this.getAllIndexes();
        }
        return this.indexNames;
    }

    public IndexRowGenerator[] getDistinctIndexRowGenerators() throws StandardException {
        if (this.distinctIndexRowGenerators == null) {
            this.getAllIndexes();
        }
        return this.distinctIndexRowGenerators;
    }

    public long[] getDistinctIndexConglomerateNumbers() throws StandardException {
        if (this.distinctIndexConglomerateNumbers == null) {
            this.getAllIndexes();
        }
        return this.distinctIndexConglomerateNumbers;
    }

    public String[] getDistinctIndexNames() throws StandardException {
        if (this.indexNames == null) {
            this.getAllIndexes();
        }
        return this.indexNames;
    }

    private void getAllIndexes() throws StandardException {
        int n;
        int n2;
        int n3 = 0;
        ConglomerateDescriptor[] conglomerateDescriptorArray = this.tableDescriptor.getConglomerateDescriptors();
        long[] lArray = new long[conglomerateDescriptorArray.length - 1];
        int n4 = 0;
        int n5 = lArray.length - 1;
        for (n2 = 0; n2 < conglomerateDescriptorArray.length; ++n2) {
            ConglomerateDescriptor conglomerateDescriptor = conglomerateDescriptorArray[n2];
            if (!conglomerateDescriptor.isIndex()) continue;
            long l = conglomerateDescriptor.getConglomerateNumber();
            for (n = 0; n < n4; ++n) {
                if (lArray[n] != l) continue;
                lArray[n5--] = n2;
                break;
            }
            if (n == n4) {
                lArray[n4++] = l;
            }
            ++n3;
        }
        this.indexRowGenerators = new IndexRowGenerator[n3];
        this.indexConglomerateNumbers = new long[n3];
        this.indexNames = new String[n3];
        this.distinctIndexRowGenerators = new IndexRowGenerator[n4];
        this.distinctIndexConglomerateNumbers = new long[n4];
        this.distinctIndexNames = new String[n4];
        n2 = lArray.length - 1;
        n = -1;
        int n6 = -1;
        for (int i = 0; i < conglomerateDescriptorArray.length; ++i) {
            ConglomerateDescriptor conglomerateDescriptor = conglomerateDescriptorArray[i];
            if (!conglomerateDescriptor.isIndex()) continue;
            this.indexRowGenerators[++n] = conglomerateDescriptor.getIndexDescriptor();
            this.indexConglomerateNumbers[n] = conglomerateDescriptor.getConglomerateNumber();
            if (!conglomerateDescriptor.isConstraint()) {
                this.indexNames[n] = conglomerateDescriptor.getConglomerateName();
            }
            if (n2 > n5 && i == (int)lArray[n2]) {
                --n2;
                continue;
            }
            this.distinctIndexRowGenerators[++n6] = this.indexRowGenerators[n];
            this.distinctIndexConglomerateNumbers[n6] = this.indexConglomerateNumbers[n];
            this.distinctIndexNames[n6] = this.indexNames[n];
        }
    }
}

