#!/usr/bin/env perl

use strict;
use warnings;

use Test::More;
use Test::Mojo;
use Mojo::ByteStream qw/b/;
use File::Temp;
use Yars;

my $t = Test::Mojo->new('Yars');
$t->app->config->servers(
    default => [ {
            disks => [
                {
                    root    => File::Temp->newdir,
                    buckets => [ '0' .. '9', 'A' .. 'F' ]
                }
            ]
        }
    ]
);
$t->app->config->{url} = $t->ua->app_url;
$t->app->config->servers->[0]{url} = $t->app->config->{url};

local $/ = undef;
my $content =b(<DATA>)->b64_decode;
my $digest = b($content)->md5_sum->to_string;

$t->put_ok("/file/my_bin_file", {}, $content)->status_is(201);
$t->get_ok("/file/my_bin_file/$digest")->content_is($content)->status_is(200);
$t->delete_ok("/file/my_bin_file/$digest")->status_is(200);

done_testing();

__DATA__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