// String based streams -*- C++ -*-

// Copyright (C) 1997-1999 Cygnus Solutions
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

// As a special exception, you may use this file as part of a free software
// library without restriction.  Specifically, if other files instantiate
// templates or use macros or inline functions from this file, or you compile
// this file and link it with other files to produce an executable, this
// file does not by itself cause the resulting executable to be covered by
// the GNU General Public License.  This exception does not however
// invalidate any other reasons why the executable file might be covered by
// the GNU General Public License.

//
// ISO C++ 14882: 27.7  String-based streams
//

#ifndef _CPP_BITS_SSTREAM_TCC
#define _CPP_BITS_SSTREAM_TCC	1

#include <bits/std_sstream.h>

namespace std {

  template <class _CharT, class _Traits, class _Alloc>
    basic_stringbuf<_CharT, _Traits, _Alloc>::int_type 
    basic_stringbuf<_CharT, _Traits, _Alloc>::pbackfail(int_type __c)
    {
      int_type __retval = traits_type::eof();
      char_type* __pcur = this->gptr();
      bool __testeof = traits_type::eq_int_type(__c, traits_type::eof());
      bool __testpos = __pcur && _M_in_beg < __pcur; 
      
      // Try to put back __c into input sequence in one of three ways.
      // Order these tests done in is unspecified by the standard.
      if (!__testeof && __testpos 
	  && traits_type::eq(traits_type::to_char_type(__c), gptr()[-1]))
	{
	  char_type __asgn = __pcur[-1];
	  *__pcur = __asgn;
	  __retval = __c;
	}
      else if (!__testeof && __testpos && _M_mode & ios_base::out)
	{
	  __pcur[-1] = __c;
	  __retval = __c;
	}
      else if (__testeof && __testpos)
	{
	  char_type __asgn = __pcur[-1];
	  *__pcur = __asgn;
	  __retval = traits_type::not_eof(__c);
	}
      return __retval;
    }
  
  template <class _CharT, class _Traits, class _Alloc>
    basic_stringbuf<_CharT, _Traits, _Alloc>::int_type 
    basic_stringbuf<_CharT, _Traits, _Alloc>::overflow(int_type __c)
    {
      int_type __retval = traits_type::eof();
      bool __testeof = traits_type::eq_int_type(__c, __retval);
      bool __testwrite = _M_out_cur && _M_out_cur < _M_out_end;
      
      // Try to append __c into output sequence in one of two ways.
      // Order these tests done in is unspecified by the standard.
      if (_M_mode & ios_base::out)
	{
	  if (!__testeof)
	    {
	      // NB: Start ostringstream buffers at 1024 bytes. This
	      // is an experimental value (pronounced "arbitrary" in
	      // some of the hipper english-speaking countries), and
	      // can be changed to suite particular needs.
	      __size_type __len = max(_M_buf_size, static_cast<int_type>(512));
	      __len *= 2;

	      if (__testwrite)
		this->sputc(__c);
	      else if (__len <= _M_string.max_size())
		{
		  // Force-allocate, re-sync.
		  _M_string.reserve(__len);
		  _M_buf_size = static_cast<int_type>(__len);
		  _M_really_sync(_M_in_cur - _M_in_beg, 
				 _M_out_cur - _M_out_beg);
		  *_M_out_cur = traits_type::to_char_type(__c);
		  ++_M_out_cur;
		  __retval = __c;
		}
	    }
	  else
	    __retval = traits_type::not_eof(__c);
	}
      return __retval;
    }

  template <class _CharT, class _Traits, class _Alloc>
    basic_stringbuf<_CharT, _Traits, _Alloc>::pos_type
    basic_stringbuf<_CharT, _Traits, _Alloc>::
    seekoff(off_type __off, ios_base::seekdir __way, ios_base::openmode __mode)
    {
      pos_type __retval =  pos_type(off_type(-1)); 
      __streambuf_type::char_type* __beg = NULL;
      __streambuf_type::char_type* __cur = NULL;
      __streambuf_type::char_type* __end = NULL;
      bool __in = __mode & ios_base::in && !(__mode & ios_base::out);
      bool __out = __mode & ios_base::out && !(__mode & ios_base::in);
      bool __both = __mode & ios_base::out && __mode & ios_base::in 
		    && __way != ios_base::cur;
      
      if (__in)
	{
	  __beg = this->eback();
	  __cur = this->gptr();
	  __end = this->egptr();
	  }
      else if (__out)
	{
	  __beg = this->pbase();
	  __cur = this->pptr();
	  __end = this->epptr();
	}
      else if (__both)
	{
	  __beg = this->pbase();
	  __end = this->epptr();
	  __cur = this->pptr() > this->gptr() ? this->pptr(): this->gptr();
	}

      if (__cur)
	{
	  off_type __newoff = 0;
	  if (__way == ios_base::cur)
	    __newoff = __cur - __beg;
	  else if (__way == ios_base::end)
	    __newoff = __end - __beg;
	  
	  if (__newoff + __off >= 0 && __end - __beg >= __newoff + __off)
	    {
	      // Need to set both of these if applicable.
	      if (__in || __both)
		_M_in_cur = _M_in_beg + __newoff + __off;
	      if (__out || __both)
		_M_out_cur = _M_out_beg + __newoff + __off;
	      __retval = pos_type(off_type(__beg + __newoff + __off));
	    }
	}
      return __retval;
    }

  template <class _CharT, class _Traits, class _Alloc>
    basic_stringbuf<_CharT, _Traits, _Alloc>::pos_type
    basic_stringbuf<_CharT, _Traits, _Alloc>::
    seekpos(pos_type __sp, ios_base::openmode __mode)
    {
      pos_type __retval =  pos_type(off_type(-1)); 
      char_type* __pos = reinterpret_cast<char_type*> (__sp._M_position());
      char_type* __beg = NULL;
      char_type* __end = NULL;
      bool __testvalid = false;
      
      if (__mode & ios_base::in)
	{
	  __beg = eback();
	  __end = egptr();
	}
      if (__mode & ios_base::out)
	{
	  __beg = pbase();
	  __end = epptr();
	}
      __testvalid = __beg <= __pos && __pos <= __end;
      if (__testvalid)
	{
	  // Need to set both of these if applicable
	  if (__mode & ios_base::in)
	    _M_in_cur = __pos;
	  if (__mode & ios_base::out)
	    _M_out_cur = __pos;
	  __retval = pos_type(off_type(__pos));
	}
      
      return __retval;
    }

} // namespace std

#endif	/* _CPP_BITS_SSTREAM_TCC */









