/* catinit.c -- open and initialize the foobar message catalog
   Copyright (C) 1994 Patrick D'Cruze

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by Patrick D'Cruze <pdcruze@iinet.com.au>. */


/* This routine uses the define -DNLS to determine whether to include
   support for the message catalog routines or not.  */

#ifdef NLS
#include <locale.h>
#include <nl_types.h>

/* Message catalog descriptor */
nl_catd catfd = -1;
#endif


#ifdef NLS
void catinit ()
{

	/* if the catalog hasn't been opened yet, it also means
	   that we haven't yet called setlocale() either - so we
	   may as well do both of them at the same time.          */

	if (catfd == (nl_catd)-1)
	{
		setlocale(LC_MESSAGES, "");
		catfd = catopen("foobar.cat", MCLoadBySet);
	}
}
#endif	
