/* Sample C code the demonstrate the use of the following locale message
   catalog functions: setlocale(); catopen(); catgets(); and catclose();
   and also allows the use of descriptive names when referring to messages
   and message sets.

   Written by Patrick D'Cruze (pdcruze@orac.iinet.com.au)
   Copyright (C) 1994 Patrick D'Cruze

   This code is licensed under the terms of thw GPL.  */


#include <stdio.h>
#include <locale.h>
#include <nl_types.h>
#include "bar-nls.h"

/* Message catalog descriptor */
static nl_catd catfd = -1;

main()
{
	int temp_num = 7;

	/* First establish the correct locale to use */
	setlocale(LC_MESSAGES, "");

	/* Now open the message catalog for this software */
	catfd = catopen("bar.cat", MCLoadBySet);

	/* We could have checked to see if the catalog was indeed opened
	   properly (by checking the value of catfd) however little is
	   to be gained.  If the catalog couldn't be opened for some
	   reason, the software will automatically use the default message
	   stored within each catgets() function                          */

	/* We're now free to start accessing the message catalog */
	printf(catgets(catfd, barSet, barFirst_Message,
		"Default first message\n"));

	printf(catgets(catfd, barSet, barError_Message,
		"Second message with integer directive = %d\n"), temp_num);

	/* The program is about to end.  Close the catalog and free the
	   memory.                                                       */
	catclose(catfd);
	return(0);
}

