// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

var common = require('../common');
var assert = require('assert');
var net = require('net');
var msg = 'test';
var stopped = true;
var server1 = net.createServer({pauseOnConnect: true}, function(socket) {
  socket.on('data', function(data) {
    if (stopped) {
      assert(false, 'data event should not have happened yet');
    }

    assert.equal(data.toString(), msg, 'invalid data received');
    socket.end();
    server1.close();
  });

  setTimeout(function() {
    assert.equal(socket.bytesRead, 0, 'no data should have been read yet');
    socket.resume();
    stopped = false;
  }, 3000);
});

var server2 = net.createServer({pauseOnConnect: false}, function(socket) {
  socket.on('data', function(data) {
    assert.equal(data.toString(), msg, 'invalid data received');
    socket.end();
    server2.close();
  });
});

server1.listen(common.PORT, function() {
  net.createConnection({port: common.PORT}).write(msg);
});

server2.listen(common.PORT + 1, function() {
  net.createConnection({port: common.PORT + 1}).write(msg);
});
