using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Windows.Forms;

namespace SmartSync
{
    class SingleInstance
    {
        public static SingleInstance Init(String sInstanceName)
        {
            return new SingleInstance(sInstanceName);
        }

        SingleInstance(String sInstanceName)
        {
            WaitForSingleInstance(sInstanceName);
        }
        ~SingleInstance()
        {
            ReleaseMutex();
        }

        private Mutex pvt_mutex=null;

        public void WaitForSingleInstance(String sInstanceName)
        {
            while (AcquireMutex(sInstanceName) == false)
            {
                System.Threading.Thread.Sleep(1000);
            }
        }

        private bool AcquireMutex(String sInstanceName)
        {
            
            try
            {
                pvt_mutex = new Mutex(false, sInstanceName);
                pvt_mutex.WaitOne(-1, false);
                return true;
            }
            catch(Exception ex)
            {
                Logger.AddEntry(Logger.EXCEPTION, "SingleInstance.AcquireMutex", "An exception has been raised. Exception description: " + ex.Message);
                return false;
            }
        }

        public void ReleaseMutex()
        {
            //if(pvt_mutex!=null)
                //pvt_mutex.ReleaseMutex();
        }
    }
}
