/*
 * Decompiled with CFR 0.152.
 */
package com.trfenv.rlk;

import com.trfenv.rlk.Debug+1;
import com.trfenv.rlk.Debug+1debugFuncActionListener;
import com.trfenv.rlk.DebugCommand;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Debug {
    private static JFrame debugWindow = new JFrame("Debug Window");
    private static JTextArea debugBox;
    private static JTextField commandBox;
    private static boolean firstTime;
    private static boolean isOff;
    private static int exLevels;
    private static LinkedList commands;
    private static LinkedList exceptions;
    public static boolean outputToConsole;
    private static UIManager.LookAndFeelInfo[] looks;

    public static void turnOn() {
        if (firstTime) {
            firstTime = !firstTime;
            Container container = debugWindow.getContentPane();
            container.setLayout(new BorderLayout());
            debugBox = new JTextArea();
            container.add((Component)new JScrollPane(debugBox), "Center");
            debugBox.setFont(new Font("Courier New", 0, 12));
            debugBox.setBackground(Color.BLACK);
            debugBox.setForeground(Color.WHITE);
            debugBox.setEditable(false);
            debugBox.setLineWrap(false);
            commandBox = new JTextField();
            commandBox.addActionListener(new DebugBoxActionListener(null));
            container.add((Component)commandBox, "South");
            new rClickMenu(debugBox);
            new rClickMenu(commandBox);
            debugWindow.setDefaultCloseOperation(3);
            debugWindow.setSize(500, 600);
            Debug.println("****** RLK DEBUGGING TOOLS ******");
            Debug.println("Type \"help\" for a list of valid commands.");
            Debug.addCommand(new Debug+1debugFuncActionListener(0), "quit", "Exits the application");
            Debug.addCommand(new Debug+1debugFuncActionListener(1), "turnOff", "Turns off debugging mode.");
            Debug.addCommand(new Debug+1debugFuncActionListener(2), "help", "Displays a list of all valid commands");
            Debug.addCommand(new Debug+1debugFuncActionListener(3), "toggle word wrap", "Toggles word wrapping.");
            Debug.addCommand(new Debug+1debugFuncActionListener(4), "cls", "Clears the debugging window of all contents.");
        }
        debugWindow.setVisible(true);
    }

    public static void addCommand(ActionListener actionListener, String string, String string2) {
        commands.add(new DebugCommand(actionListener, string, string2));
    }

    private static void printHelp() {
        for (DebugCommand debugCommand : commands) {
            Debug.println("    " + debugCommand.getName() + " - " + debugCommand.getSummary());
        }
        Debug.println("    print ex [x] - Prints an exception already thrown using the index number.");
        Debug.println("    print set levels [x] - Sets the class levels to show when displaying exceptions.");
        Debug.println("    set ui = [x] - Changes the UI look and feel.");
    }

    public static void printException(Exception exception, String string) {
        Debug.println(Debug.mPrintEx(exception, string));
        JDebugDialog jDebugDialog = new JDebugDialog(exception, string);
        exceptions.addLast(exception);
    }

    public static void printException(Exception exception) {
        String string = exception.getMessage() == null ? "" : exception.getMessage();
        Debug.printException(exception, string);
    }

    public static void reprintException(int n) {
        if (n < 0 || n > Debug.exCount()) {
            Debug.println("Invalid exception index given.");
            return;
        }
        Exception exception = (Exception)exceptions.get(n);
        if (exception.getMessage() != null) {
            Debug.println(Debug.mPrintEx(exception, exception.getMessage()));
        } else {
            Debug.println(Debug.mPrintEx(exception, ""));
        }
    }

    private static String mPrintEx(Exception exception, String string) {
        if (!firstTime) {
            String string2 = "###!!! EXCEPTION: " + exception.getClass().getName() + " -> " + string + "\n";
            StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
            int n = exLevels != -1 ? (stackTraceElementArray.length - 1 > exLevels ? exLevels : stackTraceElementArray.length) : stackTraceElementArray.length;
            for (int i = 0; i < n; ++i) {
                string2 = string2 + "    @" + stackTraceElementArray[i].getClassName() + "." + stackTraceElementArray[i].getMethodName() + " line " + stackTraceElementArray[i].getLineNumber() + "\n";
            }
            return string2;
        }
        return "";
    }

    public static int exCount() {
        return exceptions.size();
    }

    public static void setLevels(int n) {
        exLevels = n;
    }

    public static void changeLookAndFeel(int n) {
        Debug.println("Changing look and feel to the ");
        switch (n) {
            case 1: {
                Debug.print("modaf");
                break;
            }
            case 2: {
                Debug.print("win32");
                break;
            }
            default: {
                Debug.print("steel");
            }
        }
        Debug.print(" look.");
        looks = UIManager.getInstalledLookAndFeels();
        try {
            UIManager.setLookAndFeel(looks[n].getClassName());
        }
        catch (Exception exception) {
            Debug.println("The look and feel you selected is either invalid or not available on this platform.");
        }
    }

    public static void turnOff() {
        isOff = true;
    }

    public static void print(String string) {
        if (!firstTime && string != null) {
            debugBox.append(string);
        }
        try {
            debugBox.setSelectionStart(debugBox.getLineStartOffset(debugBox.getLineCount() - 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (outputToConsole) {
            System.err.print(string);
        }
    }

    public static void println(String string) {
        Debug.print("\n" + string);
    }

    public static void printWarning(String string) {
        Debug.println("WARNING: " + string);
    }

    public static void createObject(Object object) {
        Debug.println("+++ Creating object: " + object);
    }

    static /* synthetic */ void access+100() {
        Debug.printHelp();
    }

    static /* synthetic */ JTextArea access+200() {
        return debugBox;
    }

    static {
        firstTime = true;
        isOff = false;
        exLevels = -1;
        commands = new LinkedList();
        exceptions = new LinkedList();
        outputToConsole = false;
    }

    private static class rClickMenu
    extends JPopupMenu
    implements MouseListener,
    ActionListener {
        private JPopupMenu rclickMenu;
        private JMenuItem mnuCut = new JMenuItem("Cut");
        private JMenuItem mnuCopy = new JMenuItem("Copy");
        private JMenuItem mnuPaste = new JMenuItem("Paste");
        private JMenuItem mnuSelectAll = new JMenuItem("Select All");
        private JTextComponent textBox;

        public rClickMenu(JTextComponent jTextComponent) {
            this.textBox = jTextComponent;
            this.rclickMenu = new JPopupMenu();
            this.rclickMenu.add(this.mnuCut);
            this.rclickMenu.add(this.mnuCopy);
            this.rclickMenu.add(this.mnuPaste);
            this.rclickMenu.addSeparator();
            this.rclickMenu.add(this.mnuSelectAll);
            this.mnuCut.addActionListener(this);
            this.mnuCopy.addActionListener(this);
            this.mnuPaste.addActionListener(this);
            this.mnuSelectAll.addActionListener(this);
            this.textBox.addMouseListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.mnuCut) {
                this.textBox.cut();
            } else if (actionEvent.getSource() == this.mnuCopy) {
                this.textBox.copy();
            } else if (actionEvent.getSource() == this.mnuPaste) {
                this.textBox.paste();
            } else if (actionEvent.getSource() == this.mnuSelectAll) {
                this.textBox.selectAll();
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                try {
                    this.rclickMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
                catch (Exception exception) {
                    Debug.printException(exception);
                }
            }
        }
    }

    private static class JDebugDialog
    extends JDialog
    implements ActionListener {
        JButton btnEnd;
        JButton btnContinue;
        JButton btnBreak;
        Exception mEx;

        public JDebugDialog(Exception exception, String string) {
            super((Frame)debugWindow, "Program Error");
            this.mEx = exception;
            Container container = this.getContentPane();
            container.setLayout(new BorderLayout());
            this.btnEnd = new JButton("End");
            this.btnContinue = new JButton("Continue");
            this.btnBreak = new JButton("Break");
            JPanel jPanel = new JPanel(new FlowLayout());
            jPanel.add(this.btnEnd);
            jPanel.add(this.btnContinue);
            jPanel.add(this.btnBreak);
            this.btnEnd.addActionListener(this);
            this.btnContinue.addActionListener(this);
            this.btnBreak.addActionListener(this);
            JTextArea jTextArea = new JTextArea();
            jTextArea.setEditable(false);
            jTextArea.setLineWrap(true);
            jTextArea.setBackground(this.getBackground());
            jTextArea.setFont(new JLabel().getFont());
            StackTraceElement stackTraceElement = exception.getStackTrace()[0];
            jTextArea.setText("EXCEPTION: " + exception.getClass().getName() + ": " + string + ", file " + stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName());
            container.add((Component)jTextArea, "Center");
            container.add((Component)jPanel, "South");
            this.setSize(300, 150);
            this.setVisible(true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.btnEnd || actionEvent.getSource() == this.btnBreak) {
                System.exit(0);
                return;
            } else {
                if (actionEvent.getSource() == this.btnBreak) {
                    File file = new File(this.mEx.getStackTrace()[0].getFileName());
                    if (!file.canRead()) return;
                }
                if (actionEvent.getSource() != this.btnContinue) return;
                this.setVisible(false);
            }
        }
    }

    private static class DebugBoxActionListener
    implements ActionListener {
        private DebugBoxActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = commandBox.getText();
            commandBox.setText("");
            Debug.println(string);
            if (string.startsWith("print ex")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                while (stringTokenizer.hasMoreTokens()) {
                    try {
                        Debug.reprintException(Integer.parseInt(stringTokenizer.nextToken()));
                    }
                    catch (Exception exception) {
                        Debug.println("Invalid exception index given.");
                    }
                }
            } else if (string.startsWith("set ui = ")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                Debug.changeLookAndFeel(Integer.parseInt(stringTokenizer.nextToken()));
            } else if (string.startsWith("set levels ")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                try {
                    int n = Integer.parseInt(stringTokenizer.nextToken());
                    exLevels = n;
                    Debug.println("Levels set to " + String.valueOf(n));
                }
                catch (Exception exception) {
                    Debug.println("Invalid level given.");
                }
            } else {
                for (DebugCommand debugCommand : commands) {
                    if (!debugCommand.getName().equals(string)) continue;
                    debugCommand.performAction();
                    return;
                }
                Debug.println("Invalid command given.");
            }
        }

        /* synthetic */ DebugBoxActionListener(Debug+1 debug+1) {
            this();
        }
    }
}

