/*
 * Decompiled with CFR 0.152.
 */
package org.mozdev.MacroTracker.toolkit;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MComboBox
extends JPanel
implements ListSelectionListener {
    private JList lstPanel;
    private DefaultListModel mListItems = new DefaultListModel();
    private LinkedList mActionListeners;

    public MComboBox() {
        this.mListItems.addElement("test");
        this.lstPanel = new JList(this.mListItems);
        this.lstPanel.setPrototypeCellValue("Index 1234567890");
        this.lstPanel.setSelectionMode(0);
        this.lstPanel.setVisibleRowCount(3);
        this.lstPanel.setSize(100, this.lstPanel.getHeight());
        this.mListItems.remove(0);
        this.mActionListeners = new LinkedList();
        this.lstPanel.addListSelectionListener(this);
        this.lstPanel.setMaximumSize(new Dimension(5, 5));
        this.setLayout(new GridLayout(1, 1));
        this.add(new JScrollPane(this.lstPanel));
    }

    public void addActionListener(ActionListener actionListener) {
        this.mActionListeners.add(actionListener);
    }

    public boolean addItem(String string) {
        if (this.inList(string)) {
            JOptionPane.showMessageDialog(null, "This item is already in the list. Please enter a different item.");
            return false;
        }
        this.mListItems.addElement(string);
        return true;
    }

    public void removeItemAt(int n) {
        this.mListItems.remove(n);
    }

    public int getItemCount() {
        Object[] objectArray = this.mListItems.toArray();
        return objectArray.length;
    }

    public Object getSelectedItem() throws ArrayIndexOutOfBoundsException {
        return this.getItemAt(this.getSelectedIndex());
    }

    public boolean isItemSelected() {
        return this.getSelectedIndex() != -1;
    }

    public Object getItemAt(int n) {
        try {
            return this.mListItems.get(n);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public int getSelectedIndex() {
        return this.lstPanel.getSelectedIndex();
    }

    public void clear() {
        this.lstPanel.removeAll();
    }

    public void removeAllItems() {
        this.mListItems.removeAllElements();
    }

    public boolean inList(String string) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (!((String)this.getItemAt(i)).equals(string)) continue;
            return true;
        }
        return false;
    }

    public void removeSelectedItem() {
        try {
            this.removeItemAt(this.getSelectedIndex());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ActionEvent actionEvent = new ActionEvent(this, 0, listSelectionEvent.toString());
        for (ActionListener actionListener : this.mActionListeners) {
            actionListener.actionPerformed(actionEvent);
        }
    }
}

