# Use the make rule defined in this file (projectdist) 
# to bundle up the source files into
# a source distribution and a set of patch files.
# For this rule to work you must have done the 
# following before running:
#
# --If you downloaded a source tarball without checking things out from CVS,
# then you need to convert your tree to a CVS tree; see
# http://www.mozilla.org/cvs.html for info on how to do this.
#
# --You must actively be logged into Mozilla's CVS before running:
#		cvs :pserver:anonymous@cvs-mirror.mozilla.org:/cvsroot login
#   
# --You must have built the entire Mozilla source tree.

# The following variables are used by the "distribution" command.
# The root mozilla makefiles modified for BlackConnect (mozilla/)
MOZILLA_ROOT =	mozilla/allmakefiles.sh \
				mozilla/Makefile.in \
				$(NULL)

# The Java build system (mozilla/config)
JAVA_CONFIG =	mozilla/config/rules.mk \
				mozilla/config/javarules.mk \
				$(NULL)

# The root of BlackConnect (mozilla/java/xpcom/)
JAVA_XPCOM_ROOT =	mozilla/java/xpcom/README \
					mozilla/java/xpcom/RecentChanges \
					mozilla/java/xpcom/Makefile.in \
					mozilla/java/xpcom/projectdist.mk \
					$(NULL)

# The Java side of BlackConnect (mozilla/java/xpcom/java)
JAVA_SIDE =	mozilla/java/xpcom/java \
            $(NULL)

# The XPCOM side of BlackConnect (mozilla/java/xpcom/xpcom)
XPCOM_SIDE =	mozilla/java/xpcom/xpcom \
				$(NULL)

# The OpenOffice UNO side (has not been forward-ported or touched)
URP_SIDE =		mozilla/java/xpcom/urp \
				$(NULL)

# The XPCOM wrappers (mozilla/java/xpcom/wrappers)
WRAPPERS =	mozilla/java/xpcom/wrappers \
			$(NULL)

# The portion that connects the sides (mozilla/java/xpcom/connect)
CONNECTOR =	mozilla/java/xpcom/connect \
			$(NULL)

# The thread-test (mozilla/java/xpcom/thread-test)
THREAD_TEST =	mozilla/java/xpcom/thread-test \
				$(NULL)

# The unit-tests (has not been forward-ported)
UNIT_TESTS =	mozilla/java/xpcom/test \
				$(NULL)

# The BlackConnect Sample (mozilla/java/xpcom/sample)
SAMPLE =	mozilla/java/xpcom/sample \
			$(NULL)

# Changes made to xpidl.exe (mozilla/xpcom/typelib/xpidl)
XPIDL =	mozilla/xpcom/typelib/xpidl/Makefile.in \
		mozilla/xpcom/typelib/xpidl/xpidl_java.c \
		mozilla/xpcom/typelib/xpidl/xpidl_idl.c \
		$(NULL)

# Some custom added CVS files in mozilla/java/xpcom/sample and
# mozilla/java/xpcom/thread-test that we need to bundle into the
# tar files
CVS_FILES = mozilla/java/xpcom/sample \
			mozilla/java/xpcom/thread-test \
			$(NULL)

# Everything
EVERYTHING = $(MOZILLA_ROOT) \
			 $(JAVA_CONFIG) \
			 $(JAVA_XPCOM_ROOT) \
			 $(JAVA_SIDE) \
			 $(XPCOM_SIDE) \
			 $(URP_SIDE) \
			 $(WRAPPERS) \
			 $(CONNECTOR) \
			 $(THREAD_TEST) \
			 $(UNIT_TESTS) \
			 $(SAMPLE) \
			 $(XPIDL) \
			 $(NULL)

# Deprecated files and directories that are obsolete
# but still in CVS
DEPRECATED_FILES =	mozilla/java/xpcom/env.bat \
					mozilla/java/xpcom/makefile.win \
					mozilla/java/xpcom/connect/makefile.win \
					mozilla/java/xpcom/connect/src/makefile.win \
					mozilla/java/xpcom/connect/xpcom/makefile.win \
					mozilla/java/xpcom/java/makefile.win \
					mozilla/java/xpcom/java/classes/makefile.win \
					mozilla/java/xpcom/java/components/makefile.win \
					mozilla/java/xpcom/java/jni/makefile.win \
					mozilla/java/xpcom/java/loader/makefile.win \
					mozilla/java/xpcom/java/src/makefile.win \
					mozilla/java/xpcom/java/test/makefile.win \
					mozilla/java/xpcom/wrappers/makefile.win \
					mozilla/java/xpcom/xpcom/makefile.win \
					$(NULL)


DEPRECATED_DIRECTORIES =	mozilla/java/xpcom/old \
							mozilla/java/xpcom/tools \
							mozilla/java/xpcom/classes \
							mozilla/java/xpcom/java/config \
							mozilla/java/xpcom/java/import \
							mozilla/java/xpcom/java/xpidl \
							mozilla/java/xpcom/src \
							$(NULL)

DATE = $(shell date +%Y_%m_%e)

# Adds directory CVS entries 
# First argument is the directory to add, second argument
# is the CVS file to update.
# Usage:
# $(call add_cvs_directory_entry,thread-test,mozilla/java/xpcom/CVS/Entries)
add_cvs_directory_entry = \
	$(if $(call has_cvs_entry,$(1),$(2)),, \
	$(shell cd ../../..;cp -f $(2) $(2).original; echo D/$(1)//// >> $(2)) \
	)

# A make function that checks to see if a given
# file exists in the CVS/Entries file; if not,
# a line is added to that file for the given
# file.  First argument is file to check for,
# second argument is full-path to CVS Entries file
# to check:
# $(call add_cvs_entry,javarules.mk,mozilla/config/CVS/Entries)
add_cvs_entry = \
	$(if $(call has_cvs_entry,$(1),$(2)),, \
	$(shell cd ../../..; cp -f $(2) $(2).original; echo /$(1)/0/Initial FILE// >> $(2)) \
	)

# A make function that is used by add_cvs_entry
# to see if a given CVS Entry file has an entry
# for the given file.
# First argument is file to check for,
# second argument is full-path to CVS Entries file
# to check:
# $(call has_cvs_entry,javarules.mk,mozilla/config/CVS/Entries)
has_cvs_entry = $(shell cd ../../..;grep -o $(1) $(2))

projectdist: 
	# ---Remove deprecated files
	cd ../../..; \
	rm -f $(DEPRECATED_FILES); \
	rm -fr $(DEPRECATED_DIRECTORIES)
	#
	#
	# ---Make the source distribution
	make clobber; \
	cd ../../..; \
	tar -cvf blackconnect_src_$(DATE).tar $(EVERYTHING) $(CVS_FILES); \
	gzip -fv blackconnect_src_$(DATE).tar; \
	rm -f blackconnect_src_$(DATE).tar
	#
	#
	# ---Make the binary distribution of everything
	# (We do this by hand now using WinZip since its too
	# damn slow and error prone using tar and gzip).
	#cd ../..; \
	#tar -cvf blackconnect_$(DATE).tar dist; \
	#gzip -fv blackconnect_$(DATE).tar; \
	#rm -f blackconnect_$(DATE).tar
	#
	#
	# ---This is a hack:
	# Update our CVS/Entry files in the right directories to
	# record changes to new files added (since this is
	# anonymous CVS we don't have the right to 'cvs add' new
	# files).  This is the only way to get 'cvs diff' to work.
	$(call add_cvs_directory_entry,thread-test,mozilla/java/xpcom/CVS/Entries)
	$(call add_cvs_directory_entry,sample,mozilla/java/xpcom/CVS/Entries)
	$(call add_cvs_directory_entry,java,mozilla/CVS/Entries)
	$(call add_cvs_entry,javarules.mk,mozilla/config/CVS/Entries)
	$(call add_cvs_entry,RecentChanges,mozilla/java/xpcom/CVS/Entries)
	$(call add_cvs_entry,projectdist.mk,mozilla/java/xpcom/CVS/Entries)
	$(call add_cvs_entry,xpcom_exceptions.msg,mozilla/java/xpcom/java/src/CVS/Entries)
	$(call add_cvs_entry,nsIComponentManager.java,mozilla/java/xpcom/java/classes/org/mozilla/xpcom/CVS/Entries)
	$(call add_cvs_entry,nsIServiceManager.java,mozilla/java/xpcom/java/classes/org/mozilla/xpcom/CVS/Entries)
	$(call add_cvs_entry,nsISupports.java,mozilla/java/xpcom/java/classes/org/mozilla/xpcom/CVS/Entries)
	$(call add_cvs_entry,nsIXPIDLServiceManager.java,mozilla/java/xpcom/java/classes/org/mozilla/xpcom/CVS/Entries)	
	#
	#
	# ---Now generate the patch files against CVS
	cd ../../..; \
	cvs diff -D 2003-07-22 -uBbN $(MOZILLA_ROOT) > mozilla_root.patch; \
	cvs diff -D 2003-07-22 -uBbN $(JAVA_CONFIG) > java_config.patch; \
	cvs diff -D 2003-07-22 -uBbN $(JAVA_XPCOM_ROOT) > java_xpcom_root.patch; \
	cvs diff -D 2003-07-22 -uBbN $(JAVA_SIDE) > java_side.patch; \
	cvs diff -D 2003-07-22 -uBbN $(XPCOM_SIDE) > xpcom_side.patch; \
	cvs diff -D 2003-07-22 -uBbN $(WRAPPERS) > wrappers.patch; \
	cvs diff -D 2003-07-22 -uBbN $(CONNECTOR) > connector.patch; \
	cvs diff -D 2003-07-22 -uBbN $(THREAD_TEST) > thread-test.patch; \
	cvs diff -D 2003-07-22 -uBbN $(SAMPLE) > sample.patch; \
	cvs diff -D 2003-07-22 -uBbN $(XPIDL) > xpidl.patch; \
	tar -cvf blackconnect_patches_$(DATE).tar *.patch; \
	gzip -fv blackconnect_patches_$(DATE).tar; \
	rm -f blackconnect_patches_$(DATE).tar
