/* -*- Mode: java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is Brad Neuberg.
 *
 * Contributor(s):
 * Brad GNUberg <bkn3@columbia.edu>
 */
package org.mozilla.xpcom;

public class XPCOMException extends RuntimeException {
	/** The XPCOM result code for this exception. */
	protected int resultCode;

	/** The XPCOM result name, such as NS_ERROR_XPC_NOT_ENOUGH_ARGS. */
	protected String resultName;

	/** The XPCOM result message, such as "Not enough arguments". */
	protected String resultMessage;

	public XPCOMException(int resultCode, String resultName, String resultMessage) {
		super(resultName + ": " + resultMessage);
		this.resultCode = resultCode;
		this.resultName = resultName;
		this.resultMessage = resultMessage;
	}

	public int getResultCode() {
		return resultCode;
	}

	public String getResultName() {
		return resultName;
	}

	public String getResultMessage() {
		return resultMessage;
	}
} 
